<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 11:00
 */
interface BillsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Bills 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param bill primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Bills bill
 	 */
	public function insert($bill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Bills bill
 	 */
	public function update($bill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByReceivedate($value);

	public function queryByBillno($value);

	public function queryByComment($value);

	public function queryByBilldate($value);

	public function queryByKashfid($value);

	public function queryByCash($value);

	public function queryByCashvalue($value);

	public function queryByWaitvalue($value);

	public function queryByInsurance($value);

	public function queryByInsurancecompanyid($value);

	public function queryByCustomerpercent($value);

	public function queryByCustomermax($value);

	public function queryByCustomercarry($value);

	public function queryByCompanyaccept($value);

	public function queryByCompanycarry($value);

	public function queryByCard($value);

	public function queryByCardvalue($value);

	public function queryByPaymentnetworkid($value);

	public function queryByUserid($value);

	public function queryByDeleted($value);

	public function queryByKashftype($value);

	public function queryByAlloweddays($value);

	public function queryByProductstotalprice($value);

	public function queryByKashfvalue($value);

	public function queryByKashfdiscount($value);

	public function queryByNetbillvalue($value);

	public function queryByDiscounttype($value);

	public function queryByDiscountvalue($value);

	public function queryByFinalnetbillvalue($value);

	public function queryByOffline($value);

	public function queryByUploaddate($value);


	public function deleteByClientid($value);

	public function deleteByReceivedate($value);

	public function deleteByBillno($value);

	public function deleteByComment($value);

	public function deleteByBilldate($value);

	public function deleteByKashfid($value);

	public function deleteByCash($value);

	public function deleteByCashvalue($value);

	public function deleteByWaitvalue($value);

	public function deleteByInsurance($value);

	public function deleteByInsurancecompanyid($value);

	public function deleteByCustomerpercent($value);

	public function deleteByCustomermax($value);

	public function deleteByCustomercarry($value);

	public function deleteByCompanyaccept($value);

	public function deleteByCompanycarry($value);

	public function deleteByCard($value);

	public function deleteByCardvalue($value);

	public function deleteByPaymentnetworkid($value);

	public function deleteByUserid($value);

	public function deleteByDeleted($value);

	public function deleteByKashftype($value);

	public function deleteByAlloweddays($value);

	public function deleteByProductstotalprice($value);

	public function deleteByKashfvalue($value);

	public function deleteByKashfdiscount($value);

	public function deleteByNetbillvalue($value);

	public function deleteByDiscounttype($value);

	public function deleteByDiscountvalue($value);

	public function deleteByFinalnetbillvalue($value);

	public function deleteByOffline($value);

	public function deleteByUploaddate($value);


}
?>