<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-09-10 14:26
 */
interface BranchDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Branch 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param branch primary key
 	 */
	public function delete($branchId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Branch branch
 	 */
	public function insert($branch);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Branch branch
 	 */
	public function update($branch);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBranchName($value);

	public function queryByBranchDate($value);


	public function deleteByBranchName($value);

	public function deleteByBranchDate($value);


}
?>