<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-29 13:54
 */
interface BuyandruternbilldetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Buyandruternbilldetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param buyandruternbilldetail primary key
 	 */
	public function delete($buybilldetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Buyandruternbilldetail buyandruternbilldetail
 	 */
	public function insert($buyandruternbilldetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Buyandruternbilldetail buyandruternbilldetail
 	 */
	public function update($buyandruternbilldetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByParcode($value);

	public function queryByBuybillid($value);

	public function queryByBuybilldetailcatid($value);

	public function queryByBuybilldetailproductid($value);

	public function queryByBuybilldetailquantity($value);

	public function queryByBuybilldetailprice($value);

	public function queryByBuybilldetailtotalprice($value);

	public function queryByDiscountvalue($value);

	public function queryByNote($value);

	public function queryByBuybilldetaildate($value);

	public function queryByBilltype($value);


	public function deleteByParcode($value);

	public function deleteByBuybillid($value);

	public function deleteByBuybilldetailcatid($value);

	public function deleteByBuybilldetailproductid($value);

	public function deleteByBuybilldetailquantity($value);

	public function deleteByBuybilldetailprice($value);

	public function deleteByBuybilldetailtotalprice($value);

	public function deleteByDiscountvalue($value);

	public function deleteByNote($value);

	public function deleteByBuybilldetaildate($value);

	public function deleteByBilltype($value);


}
?>