<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-03-13 17:56
 */
interface CostcenterdetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Costcenterdetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param costcenterdetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Costcenterdetail costcenterdetail
 	 */
	public function insert($costcenterdetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Costcenterdetail costcenterdetail
 	 */
	public function update($costcenterdetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCostcenterid($value);

	public function queryByType($value);

	public function queryByProcessname($value);

	public function queryByModelid($value);

	public function queryByTablename($value);

	public function queryByCostdate($value);

	public function queryByUesrid($value);

	public function queryByDel($value);

	public function queryByCostamount($value);


	public function deleteByCostcenterid($value);

	public function deleteByType($value);

	public function deleteByProcessname($value);

	public function deleteByModelid($value);

	public function deleteByTablename($value);

	public function deleteByCostdate($value);

	public function deleteByUesrid($value);

	public function deleteByDel($value);

	public function deleteByCostamount($value);


}
?>