<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-07-04 11:25
 */
interface ExpenseexchangeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Expenseexchange 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param expenseexchange primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Expenseexchange expenseexchange
 	 */
	public function insert($expenseexchange);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Expenseexchange expenseexchange
 	 */
	public function update($expenseexchange);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySerialno($value);

	public function queryByProjectid($value);

	public function queryByExpensefrom($value);

	public function queryByExpenseid($value);

	public function queryByExpenseid2($value);

	public function queryByThevalue($value);

	public function queryByCostcenterid($value);

	public function queryByExpensedate($value);

	public function queryByExpensetype($value);

	public function queryByUserid($value);

	public function queryByDel($value);

	public function queryBySysdate($value);

	public function queryByEntryid($value);


	public function deleteBySerialno($value);

	public function deleteByProjectid($value);

	public function deleteByExpensefrom($value);

	public function deleteByExpenseid($value);

	public function deleteByExpenseid2($value);

	public function deleteByThevalue($value);

	public function deleteByCostcenterid($value);

	public function deleteByExpensedate($value);

	public function deleteByExpensetype($value);

	public function deleteByUserid($value);

	public function deleteByDel($value);

	public function deleteBySysdate($value);

	public function deleteByEntryid($value);


}
?>