<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-10-24 14:32
 */
interface OtherrequestDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Otherrequest 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param otherrequest primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Otherrequest otherrequest
 	 */
	public function insert($otherrequest);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Otherrequest otherrequest
 	 */
	public function update($otherrequest);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRequestTo($value);

	public function queryByRequestToId($value);

	public function queryByRequestTitle($value);

	public function queryByComment($value);

	public function queryByRequestDate($value);

	public function queryByUserId($value);


	public function deleteByRequestTo($value);

	public function deleteByRequestToId($value);

	public function deleteByRequestTitle($value);

	public function deleteByComment($value);

	public function deleteByRequestDate($value);

	public function deleteByUserId($value);


}
?>