<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-05-11 13:57
 */
interface OtherstoremovementDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Otherstoremovement 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param otherstoremovement primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Otherstoremovement otherstoremovement
 	 */
	public function insert($otherstoremovement);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Otherstoremovement otherstoremovement
 	 */
	public function update($otherstoremovement);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOprationnumber($value);

	public function queryByDeloperation($value);

	public function queryByDel($value);

	public function queryByUserid($value);


	public function deleteByOprationnumber($value);

	public function deleteByDeloperation($value);

	public function deleteByDel($value);

	public function deleteByUserid($value);


}
?>