<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-04-04 07:28
 */
interface ProductingredientsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productingredients 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productingredient primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productingredients productingredient
 	 */
	public function insert($productingredient);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productingredients productingredient
 	 */
	public function update($productingredient);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductId($value);

	public function queryByIngridientId($value);

	public function queryByUnitId($value);

	public function queryByQuantity($value);

	public function queryByUserId($value);

	public function queryByThedate($value);

	public function queryByConditions($value);


	public function deleteByProductId($value);

	public function deleteByIngridientId($value);

	public function deleteByUnitId($value);

	public function deleteByQuantity($value);

	public function deleteByUserId($value);

	public function deleteByThedate($value);

	public function deleteByConditions($value);


}
?>