<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-10-16 10:57
 */
interface ProductrequestsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productrequests 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productrequest primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productrequests productrequest
 	 */
	public function insert($productrequest);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productrequests productrequest
 	 */
	public function update($productrequest);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductid($value);

	public function queryByStoreid($value);

	public function queryByProductnoreq($value);

	public function queryByProductnoaccept($value);

	public function queryByUseridadd($value);

	public function queryByUseridresponse($value);

	public function queryByStatus($value);

	public function queryByDeleted($value);


	public function deleteByProductid($value);

	public function deleteByStoreid($value);

	public function deleteByProductnoreq($value);

	public function deleteByProductnoaccept($value);

	public function deleteByUseridadd($value);

	public function deleteByUseridresponse($value);

	public function deleteByStatus($value);

	public function deleteByDeleted($value);


}
?>