<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:06
 */
interface RentbillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Rentbill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param rentbill primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Rentbill rentbill
 	 */
	public function insert($rentbill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Rentbill rentbill
 	 */
	public function update($rentbill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByCreatedatetime($value);

	public function queryByBilltotal($value);

	public function queryByFirmbilltotal($value);

	public function queryByBillpayed($value);

	public function queryByBillreset($value);


	public function deleteByClientid($value);

	public function deleteByCreatedatetime($value);

	public function deleteByBilltotal($value);

	public function deleteByFirmbilltotal($value);

	public function deleteByBillpayed($value);

	public function deleteByBillreset($value);


}
?>