<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-12-27 23:59
 */
interface ReturnbuybillcurrDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Returnbuybillcurr 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param returnbuybillcurr primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Returnbuybillcurr returnbuybillcurr
 	 */
	public function insert($returnbuybillcurr);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Returnbuybillcurr returnbuybillcurr
 	 */
	public function update($returnbuybillcurr);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuybillid($value);

	public function queryByConversionFactor($value);

	public function queryByReturnbuybilldiscountC($value);

	public function queryByReturnbuybilltotalbillC($value);

	public function queryByReturnbuybillaftertotalbillC($value);

	public function queryByReturnbuybilltotalpayedC($value);

	public function queryByReturnbuybillfinalbillC($value);

	public function queryByReturnbuybilldirectpaymentC($value);

	public function queryByPayedtaxC($value);

	public function queryBySaveConversionFactor($value);


	public function deleteByBuybillid($value);

	public function deleteByConversionFactor($value);

	public function deleteByReturnbuybilldiscountC($value);

	public function deleteByReturnbuybilltotalbillC($value);

	public function deleteByReturnbuybillaftertotalbillC($value);

	public function deleteByReturnbuybilltotalpayedC($value);

	public function deleteByReturnbuybillfinalbillC($value);

	public function deleteByReturnbuybilldirectpaymentC($value);

	public function deleteByPayedtaxC($value);

	public function deleteBySaveConversionFactor($value);


}
?>