<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface SavedailyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Savedaily 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param savedaily primary key
 	 */
	public function delete($savedailyid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Savedaily savedaily
 	 */
	public function insert($savedaily);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Savedaily savedaily
 	 */
	public function update($savedaily);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySavedailysavebefore($value);

	public function queryBySavedailychangeamount($value);

	public function queryBySavedailychangetype($value);

	public function queryBySaveid($value);

	public function queryByProcessname($value);

	public function queryBySavedailymodelid($value);

	public function queryBySavedailysaveafter($value);

	public function queryBySavedailydate($value);

	public function queryByUserid($value);

	public function queryByTablename($value);


	public function deleteBySavedailysavebefore($value);

	public function deleteBySavedailychangeamount($value);

	public function deleteBySavedailychangetype($value);

	public function deleteBySaveid($value);

	public function deleteByProcessname($value);

	public function deleteBySavedailymodelid($value);

	public function deleteBySavedailysaveafter($value);

	public function deleteBySavedailydate($value);

	public function deleteByUserid($value);

	public function deleteByTablename($value);


}
?>