<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-03-08 08:37
 */
interface SellbillcurrDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sellbillcurr 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sellbillcurr primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sellbillcurr sellbillcurr
 	 */
	public function insert($sellbillcurr);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sellbillcurr sellbillcurr
 	 */
	public function update($sellbillcurr);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySellbillid($value);

	public function queryByConversionFactor($value);

	public function queryBySellbilldiscountC($value);

	public function queryBySellbilltotalbillC($value);

	public function queryBySellbillaftertotalbillC($value);

	public function queryBySellbilltotalpayedC($value);

	public function queryBySellbillfinalbillC($value);

	public function queryBySellbildirectpaymentC($value);

	public function queryByTaxC($value);

	public function queryByDeliveryC($value);

	public function queryByTotalafterdeliveryC($value);

	public function queryByCashPayedC($value);

	public function queryByVisaPayedC($value);

	public function queryByExtraDiscountValC($value);

	public function queryByTaxOfDiscountValC($value);

	public function queryBySaveConversionFactor($value);


	public function deleteBySellbillid($value);

	public function deleteByConversionFactor($value);

	public function deleteBySellbilldiscountC($value);

	public function deleteBySellbilltotalbillC($value);

	public function deleteBySellbillaftertotalbillC($value);

	public function deleteBySellbilltotalpayedC($value);

	public function deleteBySellbillfinalbillC($value);

	public function deleteBySellbildirectpaymentC($value);

	public function deleteByTaxC($value);

	public function deleteByDeliveryC($value);

	public function deleteByTotalafterdeliveryC($value);

	public function deleteByCashPayedC($value);

	public function deleteByVisaPayedC($value);

	public function deleteByExtraDiscountValC($value);

	public function deleteByTaxOfDiscountValC($value);

	public function deleteBySaveConversionFactor($value);


}
?>