<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-08-25 13:51
 */
interface SizecolorstoredetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sizecolorstoredetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sizecolorstoredetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sizecolorstoredetail sizecolorstoredetail
 	 */
	public function insert($sizecolorstoredetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sizecolorstoredetail sizecolorstoredetail
 	 */
	public function update($sizecolorstoredetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStoreid($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByBuyprice($value);

	public function queryBySellunitprice($value);

	public function queryByQuantity($value);

	public function queryByParcode($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);


	public function deleteByStoreid($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByBuyprice($value);

	public function deleteBySellunitprice($value);

	public function deleteByQuantity($value);

	public function deleteByParcode($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);


}
?>