<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 11:55
 */
interface SparepartstoreDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sparepartstore 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sparepartstore primary key
 	 */
	public function delete($sparepartstoreId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sparepartstore sparepartstore
 	 */
	public function insert($sparepartstore);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sparepartstore sparepartstore
 	 */
	public function update($sparepartstore);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStoreName($value);

	public function queryByStoreDate($value);

	public function queryByStoreDescription($value);

	public function queryByConditions($value);

	public function queryByUserId($value);


	public function deleteByStoreName($value);

	public function deleteByStoreDate($value);

	public function deleteByStoreDescription($value);

	public function deleteByConditions($value);

	public function deleteByUserId($value);


}
?>