<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-09-04 12:44
 */
interface TransferclientaccountsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Transferclientaccounts 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param transferclientaccount primary key
 	 */
	public function delete($transferid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Transferclientaccounts transferclientaccount
 	 */
	public function insert($transferclientaccount);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Transferclientaccounts transferclientaccount
 	 */
	public function update($transferclientaccount);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientidfrom($value);

	public function queryByClientidto($value);

	public function queryByTransfervalue($value);

	public function queryByTransferdate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByDailyentryid($value);

	public function queryByComment($value);


	public function deleteByClientidfrom($value);

	public function deleteByClientidto($value);

	public function deleteByTransfervalue($value);

	public function deleteByTransferdate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByDailyentryid($value);

	public function deleteByComment($value);


}
?>