<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface TransfermoneyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Transfermoney 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param transfermoney primary key
 	 */
	public function delete($transfermoneyid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Transfermoney transfermoney
 	 */
	public function insert($transfermoney);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Transfermoney transfermoney
 	 */
	public function update($transfermoney);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySaveidfrom($value);

	public function queryBySaveidto($value);

	public function queryByTransfermoneyvalue($value);

	public function queryByTransfermoneydate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);


	public function deleteBySaveidfrom($value);

	public function deleteBySaveidto($value);

	public function deleteByTransfermoneyvalue($value);

	public function deleteByTransfermoneydate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);


}
?>