<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-11 09:53
 */
interface WorkshopDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Workshop 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param workshop primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Workshop workshop
 	 */
	public function insert($workshop);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Workshop workshop
 	 */
	public function update($workshop);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByDescription($value);

	public function queryByThedate($value);

	public function queryByUserid($value);

	public function queryByDel($value);


	public function deleteByName($value);

	public function deleteByDescription($value);

	public function deleteByThedate($value);

	public function deleteByUserid($value);

	public function deleteByDel($value);


}
?>