<?php

/**
 * Class that operate on table 'billsproductsbuy'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2017-02-20 09:04
 */
class BillsproductsbuyMySqlDAO implements BillsproductsbuyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillsproductsbuyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM billsproductsbuy';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM billsproductsbuy ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param billsproductsbuy primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM billsproductsbuy WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillsproductsbuyMySql billsproductsbuy
     */
    public function insert($billsproductsbuy) {
        $sql = 'INSERT INTO billsproductsbuy (billid, productid, note, productno, productprice, producttotalprice, deleted, service, retproductno, rondomtxt, lastbuyprice, meanbuyprice, storeid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsproductsbuy->billid);
        $sqlQuery->setNumber($billsproductsbuy->productid);
        $sqlQuery->set($billsproductsbuy->note);
        $sqlQuery->setNumber($billsproductsbuy->productno);
        $sqlQuery->set($billsproductsbuy->productprice);
        $sqlQuery->set($billsproductsbuy->producttotalprice);
        $sqlQuery->setNumber($billsproductsbuy->deleted);
        $sqlQuery->set($billsproductsbuy->service);
        $sqlQuery->setNumber($billsproductsbuy->retproductno);
        $sqlQuery->set($billsproductsbuy->rondomtxt);
        $sqlQuery->set($billsproductsbuy->lastbuyprice);
        $sqlQuery->set($billsproductsbuy->meanbuyprice);
        $sqlQuery->setNumber($billsproductsbuy->storeid);

        $id = $this->executeInsert($sqlQuery);
        $billsproductsbuy->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillsproductsbuyMySql billsproductsbuy
     */
    public function update($billsproductsbuy) {
        $sql = 'UPDATE billsproductsbuy SET billid = ?, productid = ?, note = ?, productno = ?, productprice = ?, producttotalprice = ?, deleted = ?, service = ?, retproductno = ?, rondomtxt = ?, lastbuyprice = ?, meanbuyprice = ?, storeid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($billsproductsbuy->billid);
        $sqlQuery->setNumber($billsproductsbuy->productid);
        $sqlQuery->set($billsproductsbuy->note);
        $sqlQuery->setNumber($billsproductsbuy->productno);
        $sqlQuery->set($billsproductsbuy->productprice);
        $sqlQuery->set($billsproductsbuy->producttotalprice);
        $sqlQuery->setNumber($billsproductsbuy->deleted);
        $sqlQuery->set($billsproductsbuy->service);
        $sqlQuery->setNumber($billsproductsbuy->retproductno);
        $sqlQuery->set($billsproductsbuy->rondomtxt);
        $sqlQuery->set($billsproductsbuy->lastbuyprice);
        $sqlQuery->set($billsproductsbuy->meanbuyprice);
        $sqlQuery->setNumber($billsproductsbuy->storeid);

        $sqlQuery->setNumber($billsproductsbuy->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM billsproductsbuy';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBillid($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductno($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE productno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductprice($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE productprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProducttotalprice($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE producttotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByService($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE service = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRetproductno($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE retproductno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRondomtxt($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE rondomtxt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastbuyprice($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE lastbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMeanbuyprice($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE meanbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM billsproductsbuy WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBillid($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductno($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE productno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductprice($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE productprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProducttotalprice($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE producttotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByService($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE service = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRetproductno($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE retproductno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRondomtxt($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE rondomtxt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastbuyprice($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE lastbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMeanbuyprice($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE meanbuyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM billsproductsbuy WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillsproductsbuyMySql
     */
    protected function readRow($row) {
        $billsproductsbuy = new Billsproductsbuy();

        $billsproductsbuy->id = isset($row['id']) ? $row['id'] : '';
        $billsproductsbuy->billid = isset($row['billid']) ? $row['billid'] : '';
        $billsproductsbuy->productid = isset($row['productid']) ? $row['productid'] : '';
        $billsproductsbuy->note = isset($row['note']) ? $row['note'] : '';
        $billsproductsbuy->productno = isset($row['productno']) ? $row['productno'] : '';
        $billsproductsbuy->productprice = isset($row['productprice']) ? $row['productprice'] : '';
        $billsproductsbuy->producttotalprice = isset($row['producttotalprice']) ? $row['producttotalprice'] : '';
        $billsproductsbuy->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $billsproductsbuy->service = isset($row['service']) ? $row['service'] : '';
        $billsproductsbuy->retproductno = isset($row['retproductno']) ? $row['retproductno'] : '';
        $billsproductsbuy->rondomtxt = isset($row['rondomtxt']) ? $row['rondomtxt'] : '';
        $billsproductsbuy->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $billsproductsbuy->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $billsproductsbuy->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        //
        $billsproductsbuy->productName = isset($row['productName']) ? $row['productName'] : '';
        $billsproductsbuy->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';
        $billsproductsbuy->logo = isset($row['logo']) ? $row['logo'] : '';

        return $billsproductsbuy;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillsproductsbuyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>