<?php

/**
 * Class that operate on table 'client'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ClientMySqlDAO implements ClientDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ClientMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM client WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM client ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM client ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param client primary key
     */
    public function delete($clientid) {
        $sql = 'DELETE FROM client WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($clientid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ClientMySql client
     */
    public function insert($client) {
        $sql = 'INSERT INTO client (clientname, clientaddress, clientphone, clientmobile, clientdebt, clientdetails, conditions, clientdate, userid,clientareaid,clientcode,dailyentryid ,rondomtxt,clientStoreIds,obygyPatientId,debtLimit,typeclientid,priceTypeId,card_number,file_faida,specialDiscount,specialDiscountVal,file,addDate,mandobCollectRatio,webApiId,clientRFID,linkedSupplierId,postponeDays,studentid,taxnumber,password,clientTypeForTree,treeId,husbandNameObgy,txtNameE,facility,delegate,txtemail,commercial,valtaxnumber,clientaddress2,country,delegateid,datecustomeraccount) VALUES (? , ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($client->clientname);
        $sqlQuery->set($client->clientaddress);
        $sqlQuery->set($client->clientphone);
        $sqlQuery->set($client->clientmobile);
        $sqlQuery->set($client->clientdebt);
        $sqlQuery->setString2($client->clientdetails);
        $sqlQuery->setNumber($client->conditions);
        $sqlQuery->set($client->clientdate);
        $sqlQuery->setNumber($client->userid);
        $sqlQuery->setNumber($client->clientareaid);
        $sqlQuery->set($client->clientcode);
        $sqlQuery->setNumber($client->dailyentryid);
        $sqlQuery->set($client->rondomtxt);
        $sqlQuery->set($client->clientStoreIds);
        $sqlQuery->set((int) $client->obygyPatientId);
        $sqlQuery->setNumber((float) $client->debtLimit);
        $sqlQuery->set($client->typeclientid);
        $sqlQuery->setNumber((int) $client->priceTypeId);
        $sqlQuery->setNumber((int) $client->card_number);
        $sqlQuery->set($client->file_faida);
        $sqlQuery->setNumber((int) $client->specialDiscount);
        $sqlQuery->setNumber((float) $client->specialDiscountVal);
        $sqlQuery->set($client->file);
        $sqlQuery->set($client->addDate);
        $sqlQuery->setNumber((float) $client->mandobCollectRatio);
        $sqlQuery->setNumber((int) $client->webApiId);
        $sqlQuery->set($client->clientRFID);
        $sqlQuery->setNumber((int) $client->linkedSupplierId);
        $sqlQuery->setNumber((int) $client->postponeDays);
        $sqlQuery->setNumber((int) $client->studentid);
        $sqlQuery->set($client->taxnumber);
        $sqlQuery->set($client->password);
        $sqlQuery->setNumber((int) $client->clientTypeForTree);
        $sqlQuery->setNumber((int) $client->treeId);
        $sqlQuery->set($client->husbandNameObgy);
        $sqlQuery->set($client->txtNameE);
        $sqlQuery->set($client->facility);
        $sqlQuery->set($client->delegate);
        $sqlQuery->set($client->txtemail);
        $sqlQuery->set($client->commercial);
        $sqlQuery->set($client->valtaxnumber);
        $sqlQuery->set($client->clientaddress2);
        $sqlQuery->set($client->country);
        $sqlQuery->setNumber((int) $client->delegateid);
        $sqlQuery->set($client->datecustomeraccount);

        $id = $this->executeInsert($sqlQuery);
        $client->clientid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ClientMySql client
     */
    public function update($client) {
        $sql = 'UPDATE client SET clientname = ?, clientaddress = ?, clientphone = ?, clientmobile = ?, clientdebt = ?, clientdetails = ?, conditions = ?, clientdate = ?, userid = ?  , clientareaid = ?  ,clientcode = ?,dailyentryid = ? , rondomtxt = ?,clientStoreIds = ?, obygyPatientId = ? , debtLimit=? , typeclientid=?,priceTypeId=?,lastEditUser = ?,card_number = ?,file_faida = ?,specialDiscount = ?,specialDiscountVal = ?,file = ?,mandobCollectRatio=?,clientRFID = ?,linkedSupplierId = ?,postponeDays=?, studentid=?, taxnumber=?, password=?,clientTypeForTree=?,treeId=?,husbandNameObgy=?,txtNameE=?,facility=?,delegate=?,txtemail=?,commercial=?,valtaxnumber=?,clientaddress2=?,country=?,delegateid=?,datecustomeraccount=? WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($client->clientname);
        $sqlQuery->set($client->clientaddress);
        $sqlQuery->set($client->clientphone);
        $sqlQuery->set($client->clientmobile);
        $sqlQuery->set($client->clientdebt);
        $sqlQuery->setString2($client->clientdetails);
        $sqlQuery->setNumber($client->conditions);
        $sqlQuery->set($client->clientdate);
        $sqlQuery->setNumber($client->userid);
        $sqlQuery->setNumber($client->clientareaid);
        $sqlQuery->set($client->clientcode);
        $sqlQuery->setNumber($client->dailyentryid);
        $sqlQuery->set($client->rondomtxt);
        $sqlQuery->set($client->clientStoreIds);
        $sqlQuery->set((int) $client->obygyPatientId);
        $sqlQuery->setNumber((float) $client->debtLimit);
        $sqlQuery->set($client->typeclientid);
        $sqlQuery->setNumber((int) $client->priceTypeId);
        $sqlQuery->setNumber((int) $client->lastEditUser);
        $sqlQuery->setNumber((int) $client->card_number);
        $sqlQuery->set($client->file_faida);
        $sqlQuery->setNumber((int) $client->specialDiscount);
        $sqlQuery->setNumber((float) $client->specialDiscountVal);
        $sqlQuery->set($client->file);
        $sqlQuery->setNumber((float) $client->mandobCollectRatio);
        $sqlQuery->set($client->clientRFID);
        $sqlQuery->setNumber((int) $client->linkedSupplierId);
        $sqlQuery->setNumber((int) $client->postponeDays);
        $sqlQuery->setNumber((int) $client->studentid);
        $sqlQuery->set($client->taxnumber);
        $sqlQuery->set($client->password);
        $sqlQuery->setNumber((int) $client->clientTypeForTree);
        $sqlQuery->setNumber((int) $client->treeId);
        $sqlQuery->set($client->husbandNameObgy);
        $sqlQuery->set($client->txtNameE);
        $sqlQuery->set($client->facility);
        $sqlQuery->set($client->delegate);
        $sqlQuery->set($client->txtemail);
        $sqlQuery->set($client->commercial);
        $sqlQuery->set($client->valtaxnumber);
        $sqlQuery->set($client->clientaddress2);
        $sqlQuery->set($client->country);
        $sqlQuery->setNumber((int) $client->delegateid);
        $sqlQuery->set($client->datecustomeraccount);




        $sqlQuery->setNumber($client->clientid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM client';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientname($value) {
        $sql = 'SELECT * FROM client WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientaddress($value) {
        $sql = 'SELECT * FROM client WHERE clientaddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientphone($value) {
        $sql = 'SELECT * FROM client WHERE clientphone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientmobile($value) {
        $sql = 'SELECT * FROM client WHERE clientmobile = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdebt($value) {
        $sql = 'SELECT * FROM client WHERE clientdebt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdetails($value) {
        $sql = 'SELECT * FROM client WHERE clientdetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM client WHERE conditions = ? order by clientid';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientdate($value) {
        $sql = 'SELECT * FROM client WHERE clientdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM client WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientcode($value) {
        $sql = 'SELECT * FROM client WHERE clientcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientname($value) {
        $sql = 'DELETE FROM client WHERE clientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientaddress($value) {
        $sql = 'DELETE FROM client WHERE clientaddress = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientphone($value) {
        $sql = 'DELETE FROM client WHERE clientphone = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientmobile($value) {
        $sql = 'DELETE FROM client WHERE clientmobile = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdebt($value) {
        $sql = 'DELETE FROM client WHERE clientdebt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdetails($value) {
        $sql = 'DELETE FROM client WHERE clientdetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdele($value) {
        $sql = 'DELETE FROM client WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientdate($value) {
        $sql = 'DELETE FROM client WHERE clientdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM client WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ClientMySql
     */
    protected function readRow($row) {
        $client = new Client();

        $client->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $client->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $client->clientaddress = isset($row['clientaddress']) ? $row['clientaddress'] : '';
        $client->clientphone = isset($row['clientphone']) ? $row['clientphone'] : '';
        $client->clientmobile = isset($row['clientmobile']) ? $row['clientmobile'] : '';
        $client->clientdebt = isset($row['clientdebt']) ? $row['clientdebt'] : '';
        $client->clientdetails = isset($row['clientdetails']) ? $row['clientdetails'] : '';
        $client->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $client->clientdate = isset($row['clientdate']) ? $row['clientdate'] : '';
        $client->userid = isset($row['userid']) ? $row['userid'] : '';
        $client->value = isset($row['value']) ? $row['value'] : '';
        $client->label = isset($row['label']) ? $row['label'] : '';
        $client->clientareaid = isset($row['clientareaid']) ? $row['clientareaid'] : '';
        $client->clientcode = isset($row['clientcode']) ? $row['clientcode'] : '';

        $client->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';


        $client->rondomtxt = isset($row['rondomtxt']) ? $row['rondomtxt'] : '';
        $client->myGenSum = isset($row['myGenSum']) ? $row['myGenSum'] : '';
        $client->myDiscountSum = isset($row['myDiscountSum']) ? $row['myDiscountSum'] : '';
        $client->myTotalbillSum = isset($row['myTotalbillSum']) ? $row['myTotalbillSum'] : '';
        $client->clientareaName = isset($row['clientareaName']) ? $row['clientareaName'] : '';
        $client->governmetid = isset($row['governmetid']) ? $row['governmetid'] : '';
        $client->governmentname = isset($row['governmentname']) ? $row['governmentname'] : '';
        $client->clientStoreIds = isset($row['clientStoreIds']) ? $row['clientStoreIds'] : '';
        $client->obygyPatientId = isset($row['obygyPatientId']) ? $row['obygyPatientId'] : '';
        //fatma
        $client->areaName = isset($row['areaName']) ? $row['areaName'] : '';
        $client->lastClientDebtChangeDate = isset($row['lastClientDebtChangeDate']) ? $row['lastClientDebtChangeDate'] : '';
        $client->lastSellBillDate = isset($row['lastSellBillDate']) ? $row['lastSellBillDate'] : '';
        $client->lastReturnSellBillDate = isset($row['lastReturnSellBillDate']) ? $row['lastReturnSellBillDate'] : '';
        $client->lastSellBillAndRuternDate = isset($row['lastSellBillAndRuternDate']) ? $row['lastSellBillAndRuternDate'] : '';
        $client->debtLimit = isset($row['debtLimit']) ? $row['debtLimit'] : '';
        $client->typeclientid = isset($row['typeclientid']) ? $row['typeclientid'] : '';
        $client->priceTypeId = isset($row['priceTypeId']) ? $row['priceTypeId'] : '';
        $client->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $client->clientdebtchangeamount = isset($row['clientdebtchangeamount']) ? $row['clientdebtchangeamount'] : '';
        $client->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $client->lastEditUser = isset($row['lastEditUser']) ? $row['lastEditUser'] : '';
        $client->lastEditUserName = isset($row['lastEditUserName']) ? $row['lastEditUserName'] : '';
        $client->typeName = isset($row['typeName']) ? $row['typeName'] : '';
        $client->clientdebtcalc = isset($row['clientdebtcalc']) ? $row['clientdebtcalc'] : '';
        $client->card_number = isset($row['card_number']) ? $row['card_number'] : '';
        $client->file_faida = isset($row['file_faida']) ? $row['file_faida'] : '';
        $client->specialDiscount = isset($row['specialDiscount']) ? $row['specialDiscount'] : '';
        $client->specialDiscountVal = isset($row['specialDiscountVal']) ? $row['specialDiscountVal'] : '';
        $client->mandobCollectRatio = isset($row['mandobCollectRatio']) ? $row['mandobCollectRatio'] : '';
        $client->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';
        $client->clientRFID = isset($row['clientRFID']) ? $row['clientRFID'] : '';
        $client->linkedSupplierId = isset($row['linkedSupplierId']) ? $row['linkedSupplierId'] : '';
        $client->postponeDays = isset($row['postponeDays']) ? $row['postponeDays'] : '';
        $client->file = isset($row['file_faida']) ? $row['file'] : '';
        $client->addDate = isset($row['addDate']) ? $row['addDate'] : '';
        $client->tamweenda3mstatusid = isset($row['tamweenda3mstatusid']) ? $row['tamweenda3mstatusid'] : '';
        $client->tamweenStatus = isset($row['tamweenStatus']) ? $row['tamweenStatus'] : '';
        $client->da3mStatus = isset($row['da3mStatus']) ? $row['da3mStatus'] : '';
        $client->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $client->cardNum = isset($row['cardNum']) ? $row['cardNum'] : '';
        $client->noOfPersonsTamween = isset($row['noOfPersonsTamween']) ? $row['noOfPersonsTamween'] : '';
        $client->noOfPersonsDa3m = isset($row['noOfPersonsDa3m']) ? $row['noOfPersonsDa3m'] : '';
        $client->cardPassword = isset($row['cardPassword']) ? $row['cardPassword'] : '';
        $client->studentid = isset($row['studentid']) ? $row['studentid'] : '';
        $client->taxnumber = isset($row['taxnumber']) ? $row['taxnumber'] : '';
        $client->password = isset($row['password']) ? $row['password'] : '';
        $client->clientTypeForTree = isset($row['clientTypeForTree']) ? $row['clientTypeForTree'] : '';
        $client->treeId = isset($row['treeId']) ? $row['treeId'] : '';
        $client->husbandNameObgy = isset($row['husbandNameObgy']) ? $row['husbandNameObgy'] : '';
        $client->txtNameE = isset($row['txtNameE']) ? $row['txtNameE'] : '';
        $client->facility = isset($row['facility']) ? $row['facility'] : '';
        $client->delegate = isset($row['delegate']) ? $row['delegate'] : '';
        $client->txtemail = isset($row['txtemail']) ? $row['txtemail'] : '';
        $client->commercial = isset($row['commercial']) ? $row['commercial'] : '';
        $client->valtaxnumber = isset($row['valtaxnumber']) ? $row['valtaxnumber'] : '';
        $client->clientaddress2 = isset($row['clientaddress2']) ? $row['clientaddress2'] : '';
        $client->country = isset($row['country']) ? $row['country'] : '';

        $client->delegateid = isset($row['delegateid']) ? $row['delegateid'] : '';
        $client->deligateName = isset($row['deligateName']) ? $row['deligateName'] : '';
        $client->datecustomeraccount = isset($row['datecustomeraccount']) ? $row['datecustomeraccount'] : '';



        return $client;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ClientMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>