<?php

/**
 * Class that operate on table 'costcenterdetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-03-13 17:56
 */
class CostcenterdetailMySqlDAO implements CostcenterdetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return CostcenterdetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM costcenterdetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM costcenterdetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM costcenterdetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param costcenterdetail primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM costcenterdetail WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param CostcenterdetailMySql costcenterdetail
     */
    public function insert($costcenterdetail) {
        $sql = 'INSERT INTO costcenterdetail (costcenterid, type, processname, modelid, tablename, costdate, uesrid, del, costamount) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($costcenterdetail->costcenterid);
        $sqlQuery->setNumber($costcenterdetail->type);
        $sqlQuery->setString2($costcenterdetail->processname);
        $sqlQuery->setNumber($costcenterdetail->modelid);
        $sqlQuery->set($costcenterdetail->tablename);
        $sqlQuery->set($costcenterdetail->costdate);
        $sqlQuery->setNumber($costcenterdetail->uesrid);
        $sqlQuery->setNumber($costcenterdetail->del);
        $sqlQuery->set($costcenterdetail->costamount);

        $id = $this->executeInsert($sqlQuery);
        $costcenterdetail->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param CostcenterdetailMySql costcenterdetail
     */
    public function update($costcenterdetail) {
        $sql = 'UPDATE costcenterdetail SET costcenterid = ?, type = ?, processname = ?, modelid = ?, tablename = ?, costdate = ?, uesrid = ?, del = ?, costamount = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($costcenterdetail->costcenterid);
        $sqlQuery->setNumber($costcenterdetail->type);
        $sqlQuery->setString2($costcenterdetail->processname);
        $sqlQuery->setNumber($costcenterdetail->modelid);
        $sqlQuery->set($costcenterdetail->tablename);
        $sqlQuery->set($costcenterdetail->costdate);
        $sqlQuery->setNumber($costcenterdetail->uesrid);
        $sqlQuery->setNumber($costcenterdetail->del);
        $sqlQuery->set($costcenterdetail->costamount);

        $sqlQuery->setNumber($costcenterdetail->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM costcenterdetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCostcenterid($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByType($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByModelid($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE modelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostdate($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE costdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUesrid($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE uesrid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostamount($value) {
        $sql = 'SELECT * FROM costcenterdetail WHERE costamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCostcenterid($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByType($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByModelid($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE modelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostdate($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE costdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUesrid($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE uesrid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostamount($value) {
        $sql = 'DELETE FROM costcenterdetail WHERE costamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return CostcenterdetailMySql
     */
    protected function readRow($row) {
        $costcenterdetail = new Costcenterdetail();

        $costcenterdetail->id = isset($row['id']) ? $row['id'] : '';
        $costcenterdetail->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $costcenterdetail->type = isset($row['type']) ? $row['type'] : '';
        $costcenterdetail->processname = isset($row['processname']) ? $row['processname'] : '';
        $costcenterdetail->modelid = isset($row['modelid']) ? $row['modelid'] : '';
        $costcenterdetail->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $costcenterdetail->costdate = isset($row['costdate']) ? $row['costdate'] : '';
        $costcenterdetail->uesrid = isset($row['uesrid']) ? $row['uesrid'] : '';
        $costcenterdetail->del = isset($row['del']) ? $row['del'] : '';
        $costcenterdetail->costamount = isset($row['costamount']) ? $row['costamount'] : '';

        return $costcenterdetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return CostcenterdetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>