<?php

/**
 * Class that operate on table 'employeedoctor'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-07-22 14:39
 */
class EmployeedoctorMySqlDAO implements EmployeedoctorDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EmployeedoctorMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM employeedoctor WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM employeedoctor';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM employeedoctor ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param employeedoctor primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM employeedoctor WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EmployeedoctorMySql employeedoctor
     */
    public function insert($employeedoctor) {
        $sql = 'INSERT INTO employeedoctor (thetype, name, val, treeId, dailyentryid, userid, sysdate, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeedoctor->thetype);
        $sqlQuery->set($employeedoctor->name);
        $sqlQuery->set($employeedoctor->val);
        $sqlQuery->setNumber($employeedoctor->treeId);
        $sqlQuery->setNumber((int) $employeedoctor->dailyentryid);
        $sqlQuery->setNumber($employeedoctor->userid);
        $sqlQuery->set($employeedoctor->sysdate);
        $sqlQuery->setNumber($employeedoctor->del);

        $id = $this->executeInsert($sqlQuery);
        $employeedoctor->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EmployeedoctorMySql employeedoctor
     */
    public function update($employeedoctor) {
        $sql = 'UPDATE employeedoctor SET thetype = ?, name = ?, val = ?, treeId = ?, dailyentryid = ?, userid = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeedoctor->thetype);
        $sqlQuery->set($employeedoctor->name);
        $sqlQuery->set($employeedoctor->val);
        $sqlQuery->setNumber($employeedoctor->treeId);
        $sqlQuery->setNumber((int) $employeedoctor->dailyentryid);
        $sqlQuery->setNumber($employeedoctor->userid);
        $sqlQuery->set($employeedoctor->sysdate);
        $sqlQuery->setNumber($employeedoctor->del);

        $sqlQuery->setNumber($employeedoctor->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM employeedoctor';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByThetype($value) {
        $sql = 'SELECT * FROM employeedoctor WHERE thetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM employeedoctor WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByVal($value) {
        $sql = 'SELECT * FROM employeedoctor WHERE val = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTreeId($value) {
        $sql = 'SELECT * FROM employeedoctor WHERE treeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM employeedoctor WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM employeedoctor WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM employeedoctor WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM employeedoctor WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByThetype($value) {
        $sql = 'DELETE FROM employeedoctor WHERE thetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM employeedoctor WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByVal($value) {
        $sql = 'DELETE FROM employeedoctor WHERE val = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTreeId($value) {
        $sql = 'DELETE FROM employeedoctor WHERE treeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM employeedoctor WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM employeedoctor WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM employeedoctor WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM employeedoctor WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EmployeedoctorMySql
     */
    protected function readRow($row) {
        $employeedoctor = new Employeedoctor();

        $employeedoctor->id = $row['id'];
        $employeedoctor->thetype = $row['thetype'];
        $employeedoctor->name = $row['name'];
        $employeedoctor->val = $row['val'];
        $employeedoctor->treeId = $row['treeId'];
        $employeedoctor->dailyentryid = $row['dailyentryid'];
        $employeedoctor->userid = $row['userid'];
        $employeedoctor->sysdate = $row['sysdate'];
        $employeedoctor->del = $row['del'];

        return $employeedoctor;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EmployeedoctorMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>