<?php

/**
 * Class that operate on table 'employeedoctordebtandpay'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-07-22 14:39
 */
class EmployeedoctordebtandpayMySqlDAO implements EmployeedoctordebtandpayDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EmployeedoctordebtandpayMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM employeedoctordebtandpay';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM employeedoctordebtandpay ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param employeedoctordebtandpay primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EmployeedoctordebtandpayMySql employeedoctordebtandpay
     */
    public function insert($employeedoctordebtandpay) {
        $sql = 'INSERT INTO employeedoctordebtandpay (thetype, employeeOrDoctor, employeeOrDoctorId, saveid, paytype, whatexpens, val, dailyentryid, note, userid, sysdate, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeedoctordebtandpay->thetype);
        $sqlQuery->setNumber($employeedoctordebtandpay->employeeOrDoctor);
        $sqlQuery->setNumber($employeedoctordebtandpay->employeeOrDoctorId);
        $sqlQuery->setNumber($employeedoctordebtandpay->saveid);
        $sqlQuery->setNumber($employeedoctordebtandpay->paytype);
        $sqlQuery->setNumber($employeedoctordebtandpay->whatexpens);
        $sqlQuery->set($employeedoctordebtandpay->val);
        $sqlQuery->setNumber((int) $employeedoctordebtandpay->dailyentryid);
        $sqlQuery->setString2($employeedoctordebtandpay->note);
        $sqlQuery->setNumber($employeedoctordebtandpay->userid);
        $sqlQuery->set($employeedoctordebtandpay->sysdate);
        $sqlQuery->setNumber($employeedoctordebtandpay->del);

        $id = $this->executeInsert($sqlQuery);
        $employeedoctordebtandpay->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EmployeedoctordebtandpayMySql employeedoctordebtandpay
     */
    public function update($employeedoctordebtandpay) {
        $sql = 'UPDATE employeedoctordebtandpay SET thetype = ?, employeeOrDoctor = ?, employeeOrDoctorId = ?, saveid = ?, paytype = ?, whatexpens = ?, val = ?, dailyentryid = ?, note = ?, userid = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeedoctordebtandpay->thetype);
        $sqlQuery->setNumber($employeedoctordebtandpay->employeeOrDoctor);
        $sqlQuery->setNumber($employeedoctordebtandpay->employeeOrDoctorId);
        $sqlQuery->setNumber($employeedoctordebtandpay->saveid);
        $sqlQuery->setNumber($employeedoctordebtandpay->paytype);
        $sqlQuery->setNumber($employeedoctordebtandpay->whatexpens);
        $sqlQuery->set($employeedoctordebtandpay->val);
        $sqlQuery->setNumber((int) $employeedoctordebtandpay->dailyentryid);
        $sqlQuery->setString2($employeedoctordebtandpay->note);
        $sqlQuery->setNumber($employeedoctordebtandpay->userid);
        $sqlQuery->set($employeedoctordebtandpay->sysdate);
        $sqlQuery->setNumber($employeedoctordebtandpay->del);

        $sqlQuery->setNumber($employeedoctordebtandpay->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM employeedoctordebtandpay';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByThetype($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE thetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeOrDoctor($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE employeeOrDoctor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeOrDoctorId($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE employeeOrDoctorId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPaytype($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE paytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWhatexpens($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE whatexpens = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByVal($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE val = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM employeedoctordebtandpay WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByThetype($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE thetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeOrDoctor($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE employeeOrDoctor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeOrDoctorId($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE employeeOrDoctorId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPaytype($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE paytype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWhatexpens($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE whatexpens = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByVal($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE val = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM employeedoctordebtandpay WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EmployeedoctordebtandpayMySql
     */
    protected function readRow($row) {
        $employeedoctordebtandpay = new Employeedoctordebtandpay();

        $employeedoctordebtandpay->id = $row['id'];
        $employeedoctordebtandpay->thetype = $row['thetype'];
        $employeedoctordebtandpay->employeeOrDoctor = $row['employeeOrDoctor'];
        $employeedoctordebtandpay->employeeOrDoctorId = $row['employeeOrDoctorId'];
        $employeedoctordebtandpay->saveid = $row['saveid'];
        $employeedoctordebtandpay->paytype = $row['paytype'];
        $employeedoctordebtandpay->whatexpens = $row['whatexpens'];
        $employeedoctordebtandpay->val = $row['val'];
        $employeedoctordebtandpay->dailyentryid = $row['dailyentryid'];
        $employeedoctordebtandpay->note = $row['note'];
        $employeedoctordebtandpay->userid = $row['userid'];
        $employeedoctordebtandpay->sysdate = $row['sysdate'];
        $employeedoctordebtandpay->del = $row['del'];
        //
        $employeedoctordebtandpay->employeedoctorName = $row['employeedoctorName'];
        $employeedoctordebtandpay->savename = $row['savename'];

        return $employeedoctordebtandpay;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EmployeedoctordebtandpayMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>