<?php

/**
 * Class that operate on table 'incometype'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-19 10:51
 */
class IncometypeMySqlDAO implements IncometypeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return IncometypeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM incometype WHERE incomeTypeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM incometype';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM incometype ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param incometype primary key
     */
    public function delete($incomeTypeId) {
        $sql = 'DELETE FROM incometype WHERE incomeTypeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($incomeTypeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param IncometypeMySql incometype
     */
    public function insert($incometype) {
        $sql = 'INSERT INTO incometype (incomeTypeName, defaultValue, incomeTypeDetails, parent, incomeTypeDate, userid, conditions, studentsubjectid,treeId) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($incometype->incomeTypeName);
        $sqlQuery->set($incometype->defaultValue);
        $sqlQuery->setString2($incometype->incomeTypeDetails);
        $sqlQuery->setNumber($incometype->parent);
        $sqlQuery->set($incometype->incomeTypeDate);
        $sqlQuery->setNumber($incometype->userid);
        $sqlQuery->setNumber($incometype->conditions);
        $sqlQuery->set($incometype->studentsubjectid);
        $sqlQuery->setNumber((int) $incometype->treeId);
        //print_r($sql);


        $id = $this->executeInsert($sqlQuery);
        $incometype->incomeTypeId = $id;
        //print_r($sqlQuery);
        return $id;
    }

    /**
     * Update record in table
     *
     * @param IncometypeMySql incometype
     */
    public function update($incometype) {
        $sql = 'UPDATE incometype SET incomeTypeName = ?, defaultValue = ?, incomeTypeDetails = ?, parent = ?, incomeTypeDate = ?, userid = ?, conditions = ?, studentsubjectid = ?,treeId=? WHERE incomeTypeId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($incometype->incomeTypeName);
        $sqlQuery->set($incometype->defaultValue);
        $sqlQuery->setString2($incometype->incomeTypeDetails);
        $sqlQuery->setNumber($incometype->parent);
        $sqlQuery->set($incometype->incomeTypeDate);
        $sqlQuery->setNumber($incometype->userid);
        $sqlQuery->setNumber($incometype->conditions);
        $sqlQuery->set($incometype->studentsubjectid);
        $sqlQuery->setNumber((int) $incometype->treeId);


        $sqlQuery->setNumber($incometype->incomeTypeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM incometype';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByIncomeTypeName($value) {
        $sql = 'SELECT * FROM incometype WHERE incomeTypeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIncomeTypeDetails($value) {
        $sql = 'SELECT * FROM incometype WHERE incomeTypeDetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParent($value) {
        $sql = 'SELECT * FROM incometype WHERE parent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIncomeTypeDate($value) {
        $sql = 'SELECT * FROM incometype WHERE incomeTypeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM incometype WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM incometype WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByIncomeTypeName($value) {
        $sql = 'DELETE FROM incometype WHERE incomeTypeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIncomeTypeDetails($value) {
        $sql = 'DELETE FROM incometype WHERE incomeTypeDetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParent($value) {
        $sql = 'DELETE FROM incometype WHERE parent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIncomeTypeDate($value) {
        $sql = 'DELETE FROM incometype WHERE incomeTypeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM incometype WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM incometype WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return IncometypeMySql
     */
    protected function readRow($row) {
        $incometype = new Incometype();

        $incometype->incomeTypeId = isset($row['incomeTypeId']) ? $row['incomeTypeId'] : '';
        $incometype->incomeTypeName = isset($row['incomeTypeName']) ? $row['incomeTypeName'] : '';
        $incometype->defaultValue = isset($row['defaultValue']) ? $row['defaultValue'] : '';
        $incometype->incomeTypeDetails = isset($row['incomeTypeDetails']) ? $row['incomeTypeDetails'] : '';
        $incometype->parent = isset($row['parent']) ? $row['parent'] : '';
        $incometype->incomeTypeDate = isset($row['incomeTypeDate']) ? $row['incomeTypeDate'] : '';
        $incometype->userid = isset($row['userid']) ? $row['userid'] : '';
        $incometype->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $incometype->studentsubjectid = isset($row['studentsubjectid']) ? $row['studentsubjectid'] : '';
        $incometype->treeId = isset($row['treeId']) ? $row['treeId'] : '';


        return $incometype;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return IncometypeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>