<?php

/**
 * Class that operate on table 'lastbillidspricesupdated'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-02-10 13:28
 */
class LastbillidspricesupdatedMySqlDAO implements LastbillidspricesupdatedDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return LastbillidspricesupdatedMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM lastbillidspricesupdated WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM lastbillidspricesupdated';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM lastbillidspricesupdated ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param lastbillidspricesupdated primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM lastbillidspricesupdated WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param LastbillidspricesupdatedMySql lastbillidspricesupdated
     */
    public function insert($lastbillidspricesupdated) {
        $sql = 'INSERT INTO lastbillidspricesupdated (buybill, buyandret, retbuy, sell, sellandret, retsell,buyquantity,buyandretquantity) VALUES (?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($lastbillidspricesupdated->buybill);
        $sqlQuery->setNumber($lastbillidspricesupdated->buyandret);
        $sqlQuery->setNumber($lastbillidspricesupdated->retbuy);
        $sqlQuery->setNumber($lastbillidspricesupdated->sell);
        $sqlQuery->setNumber($lastbillidspricesupdated->sellandret);
        $sqlQuery->setNumber($lastbillidspricesupdated->retsell);
        $sqlQuery->setNumber($lastbillidspricesupdated->buyquantity);
        $sqlQuery->setNumber($lastbillidspricesupdated->buyandretquantity);

        $id = $this->executeInsert($sqlQuery);
        $lastbillidspricesupdated->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param LastbillidspricesupdatedMySql lastbillidspricesupdated
     */
    public function update($lastbillidspricesupdated) {
        $sql = 'UPDATE lastbillidspricesupdated SET buybill = ?, buyandret = ?, retbuy = ?, sell = ?, sellandret = ?, retsell = ?,buyquantity = ?,buyandretquantity = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($lastbillidspricesupdated->buybill);
        $sqlQuery->setNumber($lastbillidspricesupdated->buyandret);
        $sqlQuery->setNumber($lastbillidspricesupdated->retbuy);
        $sqlQuery->setNumber($lastbillidspricesupdated->sell);
        $sqlQuery->setNumber($lastbillidspricesupdated->sellandret);
        $sqlQuery->setNumber($lastbillidspricesupdated->retsell);
        $sqlQuery->setNumber($lastbillidspricesupdated->buyquantity);
        $sqlQuery->setNumber($lastbillidspricesupdated->buyandretquantity);

        $sqlQuery->setNumber($lastbillidspricesupdated->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM lastbillidspricesupdated';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuybill($value) {
        $sql = 'SELECT * FROM lastbillidspricesupdated WHERE buybill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuyandret($value) {
        $sql = 'SELECT * FROM lastbillidspricesupdated WHERE buyandret = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRetbuy($value) {
        $sql = 'SELECT * FROM lastbillidspricesupdated WHERE retbuy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySell($value) {
        $sql = 'SELECT * FROM lastbillidspricesupdated WHERE sell = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellandret($value) {
        $sql = 'SELECT * FROM lastbillidspricesupdated WHERE sellandret = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRetsell($value) {
        $sql = 'SELECT * FROM lastbillidspricesupdated WHERE retsell = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuybill($value) {
        $sql = 'DELETE FROM lastbillidspricesupdated WHERE buybill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuyandret($value) {
        $sql = 'DELETE FROM lastbillidspricesupdated WHERE buyandret = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRetbuy($value) {
        $sql = 'DELETE FROM lastbillidspricesupdated WHERE retbuy = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySell($value) {
        $sql = 'DELETE FROM lastbillidspricesupdated WHERE sell = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellandret($value) {
        $sql = 'DELETE FROM lastbillidspricesupdated WHERE sellandret = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRetsell($value) {
        $sql = 'DELETE FROM lastbillidspricesupdated WHERE retsell = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return LastbillidspricesupdatedMySql
     */
    protected function readRow($row) {
        $lastbillidspricesupdated = new Lastbillidspricesupdated();

        $lastbillidspricesupdated->id = $row['id'];
        $lastbillidspricesupdated->buybill = $row['buybill'];
        $lastbillidspricesupdated->buyandret = $row['buyandret'];
        $lastbillidspricesupdated->retbuy = $row['retbuy'];
        $lastbillidspricesupdated->sell = $row['sell'];
        $lastbillidspricesupdated->sellandret = $row['sellandret'];
        $lastbillidspricesupdated->retsell = $row['retsell'];
        $lastbillidspricesupdated->buyquantity = $row['buyquantity'];
        $lastbillidspricesupdated->buyandretquantity = $row['buyandretquantity'];

        return $lastbillidspricesupdated;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return LastbillidspricesupdatedMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>