<?php

/**
 * Class that operate on table 'm_comreceipt'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MComreceiptMySqlDAO implements MComreceiptDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MComreceiptMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_comreceipt WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_comreceipt';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_comreceipt ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mComreceipt primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM m_comreceipt WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MComreceiptMySql mComreceipt
     */
    public function insert($mComreceipt) {
        $sql = 'INSERT INTO m_comreceipt (receiptserial, receiptdat, branchid, clientid, totalCost, Initialcost,shipcost,documentid, userid, del, status) VALUES (?,?,?,?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mComreceipt->receiptserial);
        $sqlQuery->set($mComreceipt->receiptdat);
        $sqlQuery->setNumber($mComreceipt->branchid);
        $sqlQuery->setNumber($mComreceipt->clientid);
        $sqlQuery->set($mComreceipt->totalCost);
        $sqlQuery->set($mComreceipt->initialcost);
        $sqlQuery->set($mComreceipt->shipcost);
        $sqlQuery->setNumber($mComreceipt->documentid);
        $sqlQuery->setNumber($mComreceipt->userid);
        $sqlQuery->setNumber($mComreceipt->del);
        $sqlQuery->setNumber($mComreceipt->status);

        $id = $this->executeInsert($sqlQuery);
        $mComreceipt->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MComreceiptMySql mComreceipt
     */
    public function update($mComreceipt) {
        $sql = 'UPDATE m_comreceipt SET receiptserial = ?, receiptdat = ?, branchid = ?, clientid = ?, totalCost = ?, Initialcost = ?, shipcost = ?,userid = ?,documentid=?, del = ?, status = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mComreceipt->receiptserial);
        $sqlQuery->set($mComreceipt->receiptdat);
        $sqlQuery->setNumber($mComreceipt->branchid);
        $sqlQuery->setNumber($mComreceipt->clientid);
        $sqlQuery->set($mComreceipt->totalCost);
        $sqlQuery->set($mComreceipt->initialcost);
        $sqlQuery->set($mComreceipt->shipcost);
        $sqlQuery->setNumber($mComreceipt->documentid);
        $sqlQuery->setNumber($mComreceipt->userid);
        $sqlQuery->setNumber($mComreceipt->del);
        $sqlQuery->setNumber($mComreceipt->status);

        $sqlQuery->setNumber($mComreceipt->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_comreceipt';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByReceiptserial($value) {
        $sql = 'SELECT * FROM m_comreceipt WHERE receiptserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReceiptdat($value) {
        $sql = 'SELECT * FROM m_comreceipt WHERE receiptdat = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchid($value) {
        $sql = 'SELECT * FROM m_comreceipt WHERE branchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM m_comreceipt WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInitialcost($value) {
        $sql = 'SELECT * FROM m_comreceipt WHERE Initialcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM m_comreceipt WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_comreceipt WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStatus($value) {
        $sql = 'SELECT * FROM m_comreceipt WHERE status = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByReceiptserial($value) {
        $sql = 'DELETE FROM m_comreceipt WHERE receiptserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReceiptdat($value) {
        $sql = 'DELETE FROM m_comreceipt WHERE receiptdat = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchid($value) {
        $sql = 'DELETE FROM m_comreceipt WHERE branchid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM m_comreceipt WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInitialcost($value) {
        $sql = 'DELETE FROM m_comreceipt WHERE Initialcost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM m_comreceipt WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_comreceipt WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStatus($value) {
        $sql = 'DELETE FROM m_comreceipt WHERE status = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MComreceiptMySql
     */
    protected function readRow($row) {
        $mComreceipt = new MComreceipt();

        $mComreceipt->id = isset($row['id']) ? $row['id'] : '';
        $mComreceipt->receiptserial = isset($row['receiptserial']) ? $row['receiptserial'] : '';
        $mComreceipt->receiptdat = isset($row['receiptdat']) ? $row['receiptdat'] : '';
        $mComreceipt->branchid = isset($row['branchid']) ? $row['branchid'] : '';
        $mComreceipt->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $mComreceipt->totalCost = isset($row['totalCost']) ? $row['totalCost'] : '';
        $mComreceipt->initialcost = isset($row['Initialcost']) ? $row['Initialcost'] : '';
        $mComreceipt->userid = isset($row['userid']) ? $row['userid'] : '';
        $mComreceipt->del = isset($row['del']) ? $row['del'] : '';
        $mComreceipt->status = isset($row['status']) ? $row['status'] : '';
        $mComreceipt->productserial = isset($row['productserial']) ? $row['productserial'] : '';
        $mComreceipt->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $mComreceipt->comment = isset($row['comment']) ? $row['comment'] : '';
        $mComreceipt->shipcost = isset($row['shipcost']) ? $row['shipcost'] : '';
        $mComreceipt->currentstage = isset($row['currentstage']) ? $row['currentstage'] : '';
        $mComreceipt->documentid = isset($row['documentid']) ? $row['documentid'] : '';
        $mComreceipt->title = isset($row['title']) ? $row['title'] : '';

        $mComreceipt->value = isset($row['value']) ? $row['value'] : '';
        $mComreceipt->label = isset($row['label']) ? $row['label'] : '';


        return $mComreceipt;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MComreceiptMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>