<?php

/**
 * Class that operate on table 'm_initialmaintenance'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MInitialmaintenanceMySqlDAO implements MInitialmaintenanceDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MInitialmaintenanceMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_initialmaintenance WHERE initialMaintenanceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_initialmaintenance';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_initialmaintenance ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mInitialmaintenance primary key
     */
    public function delete($initialMaintenanceId) {
        $sql = 'DELETE FROM m_initialmaintenance WHERE initialMaintenanceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($initialMaintenanceId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MInitialmaintenanceMySql mInitialmaintenance
     */
    public function insert($mInitialmaintenance) {
        $sql = 'INSERT INTO m_initialmaintenance (ourSerial, initialMaintenanceDate, comment, userId, branchId, totalClientCost, del) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mInitialmaintenance->ourSerial);
        $sqlQuery->set($mInitialmaintenance->initialMaintenanceDate);
        $sqlQuery->setString2($mInitialmaintenance->comment);
        $sqlQuery->setNumber($mInitialmaintenance->userId);
        $sqlQuery->setNumber($mInitialmaintenance->branchId);
        $sqlQuery->set($mInitialmaintenance->totalClientCost);
        $sqlQuery->setNumber($mInitialmaintenance->del);

        $id = $this->executeInsert($sqlQuery);
        $mInitialmaintenance->initialMaintenanceId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MInitialmaintenanceMySql mInitialmaintenance
     */
    public function update($mInitialmaintenance) {
        $sql = 'UPDATE m_initialmaintenance SET ourSerial = ?, initialMaintenanceDate = ?, comment = ?, userId = ?, branchId = ?, totalClientCost = ?, del = ? WHERE initialMaintenanceId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mInitialmaintenance->ourSerial);
        $sqlQuery->set($mInitialmaintenance->initialMaintenanceDate);
        $sqlQuery->setString2($mInitialmaintenance->comment);
        $sqlQuery->setNumber($mInitialmaintenance->userId);
        $sqlQuery->setNumber($mInitialmaintenance->branchId);
        $sqlQuery->set($mInitialmaintenance->totalClientCost);
        $sqlQuery->setNumber($mInitialmaintenance->del);

        $sqlQuery->setNumber($mInitialmaintenance->initialMaintenanceId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_initialmaintenance';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOurSerial($value) {
        $sql = 'SELECT * FROM m_initialmaintenance WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInitialMaintenanceDate($value) {
        $sql = 'SELECT * FROM m_initialmaintenance WHERE initialMaintenanceDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM m_initialmaintenance WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_initialmaintenance WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_initialmaintenance WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalClientCost($value) {
        $sql = 'SELECT * FROM m_initialmaintenance WHERE totalClientCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_initialmaintenance WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOurSerial($value) {
        $sql = 'DELETE FROM m_initialmaintenance WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInitialMaintenanceDate($value) {
        $sql = 'DELETE FROM m_initialmaintenance WHERE initialMaintenanceDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM m_initialmaintenance WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_initialmaintenance WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_initialmaintenance WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalClientCost($value) {
        $sql = 'DELETE FROM m_initialmaintenance WHERE totalClientCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_initialmaintenance WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MInitialmaintenanceMySql
     */
    protected function readRow($row) {
        $mInitialmaintenance = new MInitialmaintenance();

        $mInitialmaintenance->initialMaintenanceId = isset($row['initialMaintenanceId']) ? $row['initialMaintenanceId'] : '';
        $mInitialmaintenance->ourSerial = isset($row['ourSerial']) ? $row['ourSerial'] : '';
        $mInitialmaintenance->initialMaintenanceDate = isset($row['initialMaintenanceDate']) ? $row['initialMaintenanceDate'] : '';
        $mInitialmaintenance->comment = isset($row['comment']) ? $row['comment'] : '';
        $mInitialmaintenance->userId = isset($row['userId']) ? $row['userId'] : '';
        $mInitialmaintenance->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mInitialmaintenance->totalClientCost = isset($row['totalClientCost']) ? $row['totalClientCost'] : '';
        $mInitialmaintenance->del = isset($row['del']) ? $row['del'] : '';

        return $mInitialmaintenance;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MInitialmaintenanceMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>