<?php

/**
 * Class that operate on table 'otherrequest'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-10-24 14:31
 */
class OtherrequestMySqlDAO implements OtherrequestDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return OtherrequestMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM otherrequest WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM otherrequest';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM otherrequest ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param otherrequest primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM otherrequest WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param OtherrequestMySql otherrequest
     */
    public function insert($otherrequest) {
        $sql = 'INSERT INTO otherrequest (requestTo, requestToId, requestTitle, comment, requestDate, userId ,branchId ,  seen , deleted) VALUES (? , ?, ?, ?, ?, ?, ? , ? , ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($otherrequest->requestTo);
        $sqlQuery->setNumber($otherrequest->requestToId);
        $sqlQuery->set($otherrequest->requestTitle);
        $sqlQuery->setString2($otherrequest->comment);
        $sqlQuery->set($otherrequest->requestDate);
        $sqlQuery->setNumber($otherrequest->userId);
        $sqlQuery->setNumber($otherrequest->branchId);
        $sqlQuery->setNumber($otherrequest->seen);
        $sqlQuery->setNumber($otherrequest->deleted);

        $id = $this->executeInsert($sqlQuery);
        $otherrequest->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param OtherrequestMySql otherrequest
     */
    public function update($otherrequest) {
        $sql = 'UPDATE otherrequest SET requestTo = ?, requestToId = ?, requestTitle = ?, comment = ?, requestDate = ?, userId = ? , branchId = ? , seen = ? , deleted = ?  WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($otherrequest->requestTo);
        $sqlQuery->setNumber($otherrequest->requestToId);
        $sqlQuery->set($otherrequest->requestTitle);
        $sqlQuery->setString2($otherrequest->comment);
        $sqlQuery->set($otherrequest->requestDate);
        $sqlQuery->setNumber($otherrequest->userId);
        $sqlQuery->setNumber($otherrequest->branchId);
        $sqlQuery->setNumber($otherrequest->seen);
        $sqlQuery->setNumber($otherrequest->deleted);

        $sqlQuery->setNumber($otherrequest->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM otherrequest';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRequestTo($value) {
        $sql = 'SELECT * FROM otherrequest WHERE requestTo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRequestToId($value) {
        $sql = 'SELECT * FROM otherrequest WHERE requestToId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRequestTitle($value) {
        $sql = 'SELECT * FROM otherrequest WHERE requestTitle = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM otherrequest WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRequestDate($value) {
        $sql = 'SELECT * FROM otherrequest WHERE requestDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM otherrequest WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRequestTo($value) {
        $sql = 'DELETE FROM otherrequest WHERE requestTo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRequestToId($value) {
        $sql = 'DELETE FROM otherrequest WHERE requestToId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRequestTitle($value) {
        $sql = 'DELETE FROM otherrequest WHERE requestTitle = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM otherrequest WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRequestDate($value) {
        $sql = 'DELETE FROM otherrequest WHERE requestDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM otherrequest WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return OtherrequestMySql
     */
    protected function readRow($row) {
        $otherrequest = new Otherrequest();

        $otherrequest->id = isset($row['id']) ? $row['id'] : '';
        $otherrequest->requestTo = isset($row['requestTo']) ? $row['requestTo'] : '';
        $otherrequest->requestToId = isset($row['requestToId']) ? $row['requestToId'] : '';
        $otherrequest->requestTitle = isset($row['requestTitle']) ? $row['requestTitle'] : '';
        $otherrequest->comment = isset($row['comment']) ? $row['comment'] : '';
        $otherrequest->requestDate = isset($row['requestDate']) ? $row['requestDate'] : '';
        $otherrequest->userId = isset($row['userId']) ? $row['userId'] : '';
        $otherrequest->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $otherrequest->seen = isset($row['seen']) ? $row['seen'] : '';
        $otherrequest->deleted = isset($row['deleted']) ? $row['deleted'] : '';


        ########################
        $otherrequest->userName = isset($row['userName']) ? $row['userName'] : '';
        $otherrequest->branchName = isset($row['branchName']) ? $row['branchName'] : '';
        $otherrequest->requestToName = isset($row['requestToName']) ? $row['requestToName'] : '';

        return $otherrequest;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return OtherrequestMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>