<?php
/**
 * Class that operate on table 'premium'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-04-04 21:16
 */
class PremiumMySqlDAO implements PremiumDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return PremiumMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM premium WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM premium';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM premium ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param premium primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM premium WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param PremiumMySql premium
 	 */
	public function insert($premium){
		$sql = 'INSERT INTO premium (date, value, premiumclient_id,payed,conditions,rest,payment_date) VALUES (?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($premium->date);
		$sqlQuery->setNumber($premium->value);
		$sqlQuery->setNumber($premium->premiumclientId);
		$sqlQuery->setNumber($premium->payed);
		$sqlQuery->setNumber($premium->conditions);
		$sqlQuery->setNumber($premium->rest);
		$sqlQuery->set($premium->payment_date);

		$id = $this->executeInsert($sqlQuery);	
		$premium->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param PremiumMySql premium
 	 */
	public function update($premium){
		$sql = 'UPDATE premium SET date = ?, value = ?, premiumclient_id = ?, payed = ?, conditions = ?,rest = ?,payment_date = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($premium->date);
		$sqlQuery->setNumber($premium->value);
		$sqlQuery->setNumber($premium->premiumclientId);
        $sqlQuery->setNumber($premium->payed);
        $sqlQuery->setNumber($premium->conditions);
        $sqlQuery->setNumber($premium->rest);
        $sqlQuery->set($premium->payment_date);

        $sqlQuery->setNumber($premium->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM premium';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByDate($value){
		$sql = 'SELECT * FROM premium WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByValue($value){
		$sql = 'SELECT * FROM premium WHERE value = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPremiumclientId($value){
		$sql = 'SELECT * FROM premium WHERE premiumclient_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByDate($value){
		$sql = 'DELETE FROM premium WHERE date = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByValue($value){
		$sql = 'DELETE FROM premium WHERE value = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPremiumclientId($value){
		$sql = 'DELETE FROM premium WHERE premiumclient_id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return PremiumMySql 
	 */
	protected function readRow($row){
		$premium = new Premium();
		
		$premium->id = $row['id'];
		$premium->date = $row['date'];
		$premium->value = $row['value'];
		$premium->premiumclientId = $row['premiumclient_id'];
		$premium->payed = $row['payed'];
		$premium->payment_date = $row['payment_date'];
		$premium->conditions = isset($row['conditions']) ? $row['conditions'] : '';
		$premium->premConditions = isset($row['premConditions']) ? $row['premConditions'] : '';
		$premium->countPremium = $row['countPremium'];
        $premium->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $premium->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $premium->clientaddress = isset($row['clientaddress']) ? $row['clientaddress'] : '';
        $premium->clientphone = isset($row['clientphone']) ? $row['clientphone'] : '';
        $premium->clientmobile = isset($row['clientmobile']) ? $row['clientmobile'] : '';
        $premium->clientdebt = isset($row['clientdebt']) ? $row['clientdebt'] : '';
        $premium->clientdetails = isset($row['clientdetails']) ? $row['clientdetails'] : '';
        $premium->typeName = isset($row['typeName']) ? $row['typeName'] : '';
        $premium->typeclientid = isset($row['typeclientid']) ? $row['typeclientid'] : '';
        $premium->areaName = isset($row['areaName']) ? $row['areaName'] : '';
        $premium->rest = isset($row['rest']) ? $row['rest'] : '';
        $premium->totalPremium = isset($row['totalPremium']) ? $row['totalPremium'] : '';
        $premium->restPremium = isset($row['restPremium']) ? $row['restPremium'] : '';
        $premium->totalnotpayed = isset($row['totalnotpayed']) ? $row['totalnotpayed'] : '';
        $premium->totalLate = isset($row['totalLate']) ? $row['totalLate'] : '';
        $premium->totalRest = isset($row['totalRest']) ? $row['totalRest'] : '';
        $premium->totalValueNotPayed = isset($row['totalValueNotPayed']) ? $row['totalValueNotPayed'] : '';
        $premium->totalRestNotPayed = isset($row['totalRestNotPayed']) ? $row['totalRestNotPayed'] : '';
        $premium->totalValueLate = isset($row['totalValueLate']) ? $row['totalValueLate'] : '';




        return $premium;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return PremiumMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>