<?php

/**
 * Class that operate on table 'productionoutmany'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
class ProductionoutmanyMySqlDAO implements ProductionoutmanyDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionoutmanyMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionoutmany WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionoutmany';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionoutmany ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionoutmany primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productionoutmany WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionoutmanyMySql productionoutmany
     */
    public function insert($productionoutmany) {
        $sql = 'INSERT INTO productionoutmany (outStore, inStore, supplier, comment, userid, sysDate, del,title,productionoutmanynum) VALUES (?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmany->outStore);
        $sqlQuery->setNumber($productionoutmany->inStore);
        $sqlQuery->setNumber($productionoutmany->supplier);
        $sqlQuery->setString2($productionoutmany->comment);
        $sqlQuery->setNumber($productionoutmany->userid);
        $sqlQuery->set($productionoutmany->sysDate);
        $sqlQuery->setNumber($productionoutmany->del);
        $sqlQuery->set($productionoutmany->title);
        $sqlQuery->setNumber((int) $productionoutmany->productionoutmanynum);

        $id = $this->executeInsert($sqlQuery);
        $productionoutmany->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionoutmanyMySql productionoutmany
     */
    public function update($productionoutmany) {
        $sql = 'UPDATE productionoutmany SET outStore = ?, inStore = ?, supplier = ?, comment = ?, userid = ?, sysDate = ?, del = ?,title=?,productionoutmanynum=? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmany->outStore);
        $sqlQuery->setNumber($productionoutmany->inStore);
        $sqlQuery->setNumber($productionoutmany->supplier);
        $sqlQuery->setString2($productionoutmany->comment);
        $sqlQuery->setNumber($productionoutmany->userid);
        $sqlQuery->set($productionoutmany->sysDate);
        $sqlQuery->setNumber($productionoutmany->del);
        $sqlQuery->set($productionoutmany->title);
        $sqlQuery->setNumber((int) $productionoutmany->productionoutmanynum);

        $sqlQuery->setNumber($productionoutmany->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionoutmany';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOutStore($value) {
        $sql = 'SELECT * FROM productionoutmany WHERE outStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInStore($value) {
        $sql = 'SELECT * FROM productionoutmany WHERE inStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplier($value) {
        $sql = 'SELECT * FROM productionoutmany WHERE supplier = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM productionoutmany WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM productionoutmany WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysDate($value) {
        $sql = 'SELECT * FROM productionoutmany WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM productionoutmany WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOutStore($value) {
        $sql = 'DELETE FROM productionoutmany WHERE outStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInStore($value) {
        $sql = 'DELETE FROM productionoutmany WHERE inStore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplier($value) {
        $sql = 'DELETE FROM productionoutmany WHERE supplier = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM productionoutmany WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM productionoutmany WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysDate($value) {
        $sql = 'DELETE FROM productionoutmany WHERE sysDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM productionoutmany WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionoutmanyMySql
     */
    protected function readRow($row) {
        $productionoutmany = new Productionoutmany();

        $productionoutmany->id = $row['id'];
        $productionoutmany->outStore = $row['outStore'];
        $productionoutmany->inStore = $row['inStore'];
        $productionoutmany->supplier = $row['supplier'];
        $productionoutmany->comment = $row['comment'];
        $productionoutmany->userid = $row['userid'];
        $productionoutmany->sysDate = $row['sysDate'];
        $productionoutmany->del = $row['del'];
        $productionoutmany->title = $row['title'];
        $productionoutmany->productionoutmanynum = $row['productionoutmanynum'];

        //
        $productionoutmany->productName = $row['productName'];
        $productionoutmany->productCatName = $row['productCatName'];
        $productionoutmany->sizeName = $row['sizeName'];
        $productionoutmany->colorName = $row['colorName'];
        $productionoutmany->suppliername = $row['suppliername'];
        $productionoutmany->storeNameOut = $row['storeNameOut'];
        $productionoutmany->storeNameIn = $row['storeNameIn'];
        $productionoutmany->dailyentryid = $row['dailyentryid'];

        return $productionoutmany;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionoutmanyMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>