<?php

/**
 * Class that operate on table 'productserial'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ProductserialMySqlDAO implements ProductserialDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductserialMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productserial WHERE productserailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productserial';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productserial ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productserial primary key
     */
    public function delete($productserailid) {
        $sql = 'DELETE FROM productserial WHERE productserailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productserailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductserialMySql productserial
     */
    public function insert($productserial, $comment) {
        $sql = 'INSERT INTO productserial (productid, serialnumber,comment,startdate,enddate,billid,type,buybilldetailid,don,storeid,sizeid,colorid,chassisNo,motorNo,theColor) VALUES (?, ?,"' . $comment . '",?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productserial->productid);
        $sqlQuery->set($productserial->serialnumber);

        //$sqlQuery->set($productserial->comment);
        $sqlQuery->set($productserial->startdate);
        $sqlQuery->set($productserial->enddate);
        $sqlQuery->setNumber($productserial->billid);
        $sqlQuery->setNumber($productserial->type);
        $sqlQuery->setNumber($productserial->buybilldetailid);
        $sqlQuery->setNumber($productserial->don);
        $sqlQuery->setNumber((int) $productserial->storeid);
        $sqlQuery->setNumber((int) $productserial->sizeid);
        $sqlQuery->setNumber((int) $productserial->colorid);
        $sqlQuery->set($productserial->chassisNo);
        $sqlQuery->set($productserial->motorNo);
        $sqlQuery->set($productserial->theColor);





        $id = $this->executeInsert($sqlQuery);
        $productserial->productserailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductserialMySql productserial
     */
    public function update($productserial, $comment) {
        $sql = 'UPDATE productserial SET productid = ?, serialnumber = ? ,comment= "' . $comment . '" ,
		startdate=?,enddate=?,billid=?,don=?,sizeid = ?,colorid = ?,chassisNo=?,motorNo=?,theColor=?
		 WHERE productserailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productserial->productid);
        $sqlQuery->set($productserial->serialnumber);

        //$sqlQuery->set($productserial->comment);
        $sqlQuery->set($productserial->startdate);
        $sqlQuery->set($productserial->enddate);
        $sqlQuery->setNumber($productserial->billid);
        $sqlQuery->setNumber((int) $productserial->don);
        $sqlQuery->setNumber((int) $productserial->sizeid);
        $sqlQuery->setNumber((int) $productserial->colorid);
        $sqlQuery->set($productserial->chassisNo);
        $sqlQuery->set($productserial->motorNo);
        $sqlQuery->set($productserial->theColor);


        $sqlQuery->setNumber($productserial->productserailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productserial';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productserial WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySerialnumber($value) {
        $sql = 'SELECT * FROM productserial WHERE serialnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productserial WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySerialnumber($value) {
        $sql = 'DELETE FROM productserial WHERE serialnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductserialMySql
     */
    protected function readRow($row) {
        $productserial = new Productserial();

        $productserial->productserailid = isset($row['productserailid']) ? $row['productserailid'] : '';
        $productserial->productid = isset($row['productid']) ? $row['productid'] : '';
        $productserial->serialnumber = isset($row['serialnumber']) ? $row['serialnumber'] : '';

        $productserial->comment = isset($row['comment']) ? $row['comment'] : '';
        $productserial->startdate = isset($row['startdate']) ? $row['startdate'] : '';
        $productserial->enddate = isset($row['enddate']) ? $row['enddate'] : '';
        $productserial->billid = isset($row['billid']) ? $row['billid'] : '';
        $productserial->type = isset($row['type']) ? $row['type'] : '';
        $productserial->buybilldetailid = isset($row['buybilldetailid']) ? $row['buybilldetailid'] : '';

        $productserial->productName = isset($row['productName']) ? $row['productName'] : '';

        $productserial->don = isset($row['don']) ? $row['don'] : '';
        $productserial->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $productserial->del = isset($row['del']) ? $row['del'] : '';
        $productserial->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $productserial->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $productserial->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $productserial->chassisNo = isset($row['chassisNo']) ? $row['chassisNo'] : '';
        $productserial->motorNo = isset($row['motorNo']) ? $row['motorNo'] : '';
        $productserial->theColor = isset($row['theColor']) ? $row['theColor'] : '';
        $productserial->different = isset($row['different']) ? $row['different'] : '';
        $productserial->sellbilltype = isset($row['sellbilltype']) ? $row['sellbilltype'] : '';
        $productserial->quantity = isset($row['quantity']) ? $row['quantity'] : '';
        $productserial->soldsellbillid = isset($row['soldsellbillid']) ? $row['soldsellbillid'] : '';

        $productserial->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';
        $productserial->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';

        $productserial->buybilldate = isset($row['buybilldate']) ? $row['buybilldate'] : '';
        $productserial->expireDate = isset($row['expireDate']) ? $row['expireDate'] : '';

        $productserial->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $productserial->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $productserial->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $productserial->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $productserial->productSellAllPrice = isset($row['productSellAllPrice']) ? $row['productSellAllPrice'] : '';
        $productserial->productSellUnitPrice = isset($row['productSellUnitPrice']) ? $row['productSellUnitPrice'] : '';
        $productserial->productSellHalfPrice = isset($row['productSellHalfPrice']) ? $row['productSellHalfPrice'] : '';
        $productserial->productDescription = isset($row['productDescription']) ? $row['productDescription'] : '';



        return $productserial;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductserialMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>