<?php

/**
 * Class that operate on table 'producttemp'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-05-07 12:40
 */
class ProducttempMySqlDAO implements ProducttempDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProducttempMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM producttemp WHERE producttempid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM producttemp';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM producttemp ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param producttemp primary key
     */
    public function delete($producttempid) {
        $sql = 'DELETE FROM producttemp WHERE producttempid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($producttempid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProducttempMySql producttemp
     */
    public function insert($producttemp) {
        $sql = 'INSERT INTO producttemp (productName, productCatId, productBuyPrice, productSellAllPrice, productSellUnitPrice, productSellHalfPrice, productDate, conditions, userId, parcode) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($producttemp->productName);
        $sqlQuery->setNumber($producttemp->productCatId);
        $sqlQuery->set($producttemp->productBuyPrice);
        $sqlQuery->set($producttemp->productSellAllPrice);
        $sqlQuery->set($producttemp->productSellUnitPrice);
        $sqlQuery->set($producttemp->productSellHalfPrice);
        $sqlQuery->set($producttemp->productDate);
        $sqlQuery->setNumber($producttemp->conditions);
        $sqlQuery->setNumber($producttemp->userId);
        $sqlQuery->set($producttemp->parcode);

        $id = $this->executeInsert($sqlQuery);
        $producttemp->producttempid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProducttempMySql producttemp
     */
    public function update($producttemp) {
        $sql = 'UPDATE producttemp SET productName = ?, productCatId = ?, productBuyPrice = ?, productSellAllPrice = ?, productSellUnitPrice = ?, productSellHalfPrice = ?, productDate = ?, conditions = ?, userId = ?, parcode = ? WHERE producttempid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($producttemp->productName);
        $sqlQuery->setNumber($producttemp->productCatId);
        $sqlQuery->set($producttemp->productBuyPrice);
        $sqlQuery->set($producttemp->productSellAllPrice);
        $sqlQuery->set($producttemp->productSellUnitPrice);
        $sqlQuery->set($producttemp->productSellHalfPrice);
        $sqlQuery->set($producttemp->productDate);
        $sqlQuery->setNumber($producttemp->conditions);
        $sqlQuery->setNumber($producttemp->userId);
        $sqlQuery->set($producttemp->parcode);

        $sqlQuery->setNumber($producttemp->producttempid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM producttemp';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductName($value) {
        $sql = 'SELECT * FROM producttemp WHERE productName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductCatId($value) {
        $sql = 'SELECT * FROM producttemp WHERE productCatId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductBuyPrice($value) {
        $sql = 'SELECT * FROM producttemp WHERE productBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductSellAllPrice($value) {
        $sql = 'SELECT * FROM producttemp WHERE productSellAllPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductSellUnitPrice($value) {
        $sql = 'SELECT * FROM producttemp WHERE productSellUnitPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductSellHalfPrice($value) {
        $sql = 'SELECT * FROM producttemp WHERE productSellHalfPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductDate($value) {
        $sql = 'SELECT * FROM producttemp WHERE productDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM producttemp WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM producttemp WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM producttemp WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductName($value) {
        $sql = 'DELETE FROM producttemp WHERE productName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductCatId($value) {
        $sql = 'DELETE FROM producttemp WHERE productCatId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductBuyPrice($value) {
        $sql = 'DELETE FROM producttemp WHERE productBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductSellAllPrice($value) {
        $sql = 'DELETE FROM producttemp WHERE productSellAllPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductSellUnitPrice($value) {
        $sql = 'DELETE FROM producttemp WHERE productSellUnitPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductSellHalfPrice($value) {
        $sql = 'DELETE FROM producttemp WHERE productSellHalfPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductDate($value) {
        $sql = 'DELETE FROM producttemp WHERE productDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM producttemp WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM producttemp WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM producttemp WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProducttempMySql
     */
    protected function readRow($row) {
        $producttemp = new Producttemp();

        $producttemp->producttempid = isset($row['producttempid']) ? $row['producttempid'] : '';
        $producttemp->productName = isset($row['productName']) ? $row['productName'] : '';
        $producttemp->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';
        $producttemp->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $producttemp->productSellAllPrice = isset($row['productSellAllPrice']) ? $row['productSellAllPrice'] : '';
        $producttemp->productSellUnitPrice = isset($row['productSellUnitPrice']) ? $row['productSellUnitPrice'] : '';
        $producttemp->productSellHalfPrice = isset($row['productSellHalfPrice']) ? $row['productSellHalfPrice'] : '';
        $producttemp->productDate = isset($row['productDate']) ? $row['productDate'] : '';
        $producttemp->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $producttemp->userId = isset($row['userId']) ? $row['userId'] : '';
        $producttemp->parcode = isset($row['parcode']) ? $row['parcode'] : '';

        return $producttemp;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProducttempMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>