<?php

/**
 * Class that operate on table 'project'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:04
 */
class ProjectMySqlDAO implements ProjectDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProjectMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM project WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM project';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM project ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param project primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM project WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProjectMySql project
     */
    public function insert($project) {
        $sql = 'INSERT INTO project (name, totalcontract, image, detail, clientid, costcenterid,treeid,treeproid,entryid,sysdate,del,finish,projectkindid,bannerdesigned,projectsuit,addeddate,expirydate,owner_name,business_type,supervision_type,supervision_amount,projectstageids,userid,projectstagesdata,projecttimetableitems,expenses,income,showpdf,filepdf) VALUES (?,?,?,?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($project->name);
        $sqlQuery->set($project->totalcontract);
        $sqlQuery->set($project->image);
        $sqlQuery->setString2($project->detail);
        $sqlQuery->setNumber($project->clientid);
        $sqlQuery->setNumber($project->costcenterid);
        $sqlQuery->setNumber($project->treeid);
        $sqlQuery->setNumber($project->treeproid);
        $sqlQuery->setNumber($project->entryid);
        $sqlQuery->set($project->sysdate);
        $sqlQuery->setNumber($project->del);
        $sqlQuery->setNumber($project->finish);
        $sqlQuery->set($project->projectkindid);
        $sqlQuery->set($project->bannerdesigned);
        $sqlQuery->set($project->projectsuit);
        $sqlQuery->set($project->addeddate);
        $sqlQuery->set($project->expirydate);
        $sqlQuery->set($project->owner_name);
        $sqlQuery->setNumber($project->business_type);
        $sqlQuery->setNumber($project->supervision_type);
        $sqlQuery->set($project->supervision_amount);
        $sqlQuery->set($project->projectstageids);
        $sqlQuery->setNumber($project->userid);
        $sqlQuery->setNumber($project->projectstagesdata);
        $sqlQuery->setNumber($project->projecttimetableitems);
        $sqlQuery->setNumber($project->expenses);
        $sqlQuery->setNumber($project->income);
        $sqlQuery->setNumber($project->showpdf);
        $sqlQuery->set($project->filepdf);

        $id = $this->executeInsert($sqlQuery);
        $project->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProjectMySql project
     */
    public function update($project) {
        $sql = 'UPDATE project SET name = ?, totalcontract = ?, image = ?, detail = ?, clientid = ?, costcenterid = ?,treeid =?,treeproid =? ,entryid = ? ,sysdate = ?,del =?, finish = ?,projectkindid =? ,bannerdesigned = ? ,projectsuit = ?,addeddate =?, expirydate = ?, owner_name = ?, business_type = ?, supervision_type = ?, supervision_amount = ?, projectstageids = ?, userid = ?, projectstagesdata = ?, projecttimetableitems = ?, expenses = ?, income = ?, showpdf = ?, filepdf = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($project->name);
        $sqlQuery->set($project->totalcontract);
        $sqlQuery->set($project->image);
        $sqlQuery->setString2($project->detail);
        $sqlQuery->setNumber($project->clientid);
        $sqlQuery->setNumber($project->costcenterid);
        $sqlQuery->setNumber($project->treeid);
        $sqlQuery->setNumber($project->treeproid);
        $sqlQuery->setNumber($project->entryid);
        $sqlQuery->set($project->sysdate);
        $sqlQuery->setNumber($project->del);
        $sqlQuery->setNumber($project->finish);
        $sqlQuery->set($project->projectkindid);
        $sqlQuery->set($project->bannerdesigned);
        $sqlQuery->set($project->projectsuit);
        $sqlQuery->set($project->addeddate);
        $sqlQuery->set($project->expirydate);
        $sqlQuery->set($project->owner_name);
        $sqlQuery->setNumber($project->business_type);
        $sqlQuery->setNumber($project->supervision_type);
        $sqlQuery->set($project->supervision_amount);
        $sqlQuery->set($project->projectstageids);
        $sqlQuery->setNumber($project->userid);
        $sqlQuery->setNumber($project->projectstagesdata);
        $sqlQuery->setNumber($project->projecttimetableitems);
        $sqlQuery->setNumber($project->expenses);
        $sqlQuery->setNumber($project->income);
        $sqlQuery->setNumber($project->showpdf);
        $sqlQuery->set($project->filepdf);
        
        $sqlQuery->setNumber($project->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM project';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM project WHERE name = ? ';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalcontract($value) {
        $sql = 'SELECT * FROM project WHERE totalcontract = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByImage($value) {
        $sql = 'SELECT * FROM project WHERE image = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDetail($value) {
        $sql = 'SELECT * FROM project WHERE detail = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM project WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostcenterid($value) {
        $sql = 'SELECT * FROM project WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM project WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalcontract($value) {
        $sql = 'DELETE FROM project WHERE totalcontract = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByImage($value) {
        $sql = 'DELETE FROM project WHERE image = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDetail($value) {
        $sql = 'DELETE FROM project WHERE detail = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM project WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostcenterid($value) {
        $sql = 'DELETE FROM project WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProjectMySql
     */
    protected function readRow($row) {
        $project = new Project();

        $project->id = isset($row['id']) ? $row['id'] : '';
        $project->name = isset($row['name']) ? $row['name'] : '';
        $project->totalcontract = isset($row['totalcontract']) ? $row['totalcontract'] : '';
        $project->image = isset($row['image']) ? $row['image'] : '';
        $project->detail = isset($row['detail']) ? $row['detail'] : '';
        $project->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $project->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $project->treeid = isset($row['treeid']) ? $row['treeid'] : '';
        $project->treeproid = isset($row['treeproid']) ? $row['treeproid'] : '';
        $project->entryid = isset($row['entryid']) ? $row['entryid'] : '';
        $project->sysdate = isset($row['sysdate']) ? $row['sysdate'] : '';
        $project->del = isset($row['del']) ? $row['del'] : '';
        $project->finish = isset($row['finish']) ? $row['finish'] : '';
        $project->projectkindid = isset($row['projectkindid']) ? $row['projectkindid'] : '';
        $project->bannerdesigned = isset($row['bannerdesigned']) ? $row['bannerdesigned'] : '';
        $project->projectsuit = isset($row['projectsuit']) ? $row['projectsuit'] : '';
        $project->addeddate = isset($row['addeddate']) ? $row['addeddate'] : '';
        $project->expirydate = isset($row['expirydate']) ? $row['expirydate'] : '';
        $project->projectkindname = isset($row['projectkindname']) ? $row['projectkindname'] : '';
        
        $project->sumincomevalue = isset($row['sumincomevalue']) ? $row['sumincomevalue'] : '';
        $project->sumexpensesvalue = isset($row['sumexpensesvalue']) ? $row['sumexpensesvalue'] : '';
        $project->projectexchmaterialtotal = isset($row['projectexchmaterialtotal']) ? $row['projectexchmaterialtotal'] : '';
        $project->projectexchmaterialreturntotal = isset($row['projectexchmaterialreturntotal']) ? $row['projectexchmaterialreturntotal'] : '';
        $project->supplierdebtchangeamounttotal = isset($row['supplierdebtchangeamounttotal']) ? $row['supplierdebtchangeamounttotal'] : '';
        $project->owner_name = isset($row['owner_name']) ? $row['owner_name'] : '';
        $project->business_type = isset($row['business_type']) ? $row['business_type'] : '';
        $project->supervision_type = isset($row['supervision_type']) ? $row['supervision_type'] : '';
        $project->supervision_amount = isset($row['supervision_amount']) ? $row['supervision_amount'] : '';
        $project->projectstageids = isset($row['projectstageids']) ? $row['projectstageids'] : '';
        $project->userid = isset($row['userid']) ? $row['userid'] : '';
        $project->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $project->projectstagesdata = isset($row['projectstagesdata']) ? $row['projectstagesdata'] : '';
        $project->projecttimetableitems = isset($row['projecttimetableitems']) ? $row['projecttimetableitems'] : '';
        $project->expenses = isset($row['expenses']) ? $row['expenses'] : '';
        $project->income = isset($row['income']) ? $row['income'] : '';
        $project->showpdf = isset($row['showpdf']) ? $row['showpdf'] : '';
        $project->filepdf = isset($row['filepdf']) ? $row['filepdf'] : '';





        return $project;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProjectMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>