<?php

/**
 * Class that operate on table 'save'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class SaveMySqlDAO implements SaveDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SaveMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM save WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM save';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM save ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param save primary key
     */
    public function delete($saveid) {
        $sql = 'DELETE FROM save WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($saveid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SaveMySql save
     */
    public function insert($save, $savedetails) {
        if (!isset($save->currencyId) || empty($save->currencyId)) {
            $save->currencyId = 1;
        }
        $sql = 'INSERT INTO save (savename, savecurrentvalue, savedetails, savedate, conditions, userid, currencyId, sortby,treeId,saveTreeParentType) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($save->savename);
        $sqlQuery->set($save->savecurrentvalue);
        $sqlQuery->setString2($savedetails);
        $sqlQuery->set($save->savedate);
        $sqlQuery->setNumber($save->conditions);
        $sqlQuery->setNumber($save->userid);
        $sqlQuery->setNumber((int) $save->currencyId);
        $sqlQuery->setNumber($save->sortby);
        $sqlQuery->setNumber((int) $save->treeId);
        $sqlQuery->setNumber((int) $save->saveTreeParentType);


        $id = $this->executeInsert($sqlQuery);
        $save->saveid = $id;

        return $id;
    }

    /**
     * Update record in table
     *
     * @param SaveMySql save
     */
    public function update($save, $savedetails = '') {
        $sql = 'UPDATE save SET savename = ?, savecurrentvalue = ?, savedetails = ?, savedate = ?, conditions = ?, userid = ?, sortby= ?,treeId=?,saveTreeParentType=? WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($save->savename);
        $sqlQuery->set($save->savecurrentvalue);
        $sqlQuery->setString2($savedetails);
        $sqlQuery->set($save->savedate);
        $sqlQuery->setNumber($save->conditions);
        $sqlQuery->setNumber($save->userid);
        $sqlQuery->setNumber($save->sortby);
        $sqlQuery->setNumber((int) $save->treeId);
        $sqlQuery->setNumber((int) $save->saveTreeParentType);

        $sqlQuery->setNumber($save->saveid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM save';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySavename($value) {
        $sql = 'SELECT * FROM save WHERE savename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavecurrentvalue($value) {
        $sql = 'SELECT * FROM save WHERE savecurrentvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavedetails($value) {
        $sql = 'SELECT * FROM save WHERE savedetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySavedate($value) {
        $sql = 'SELECT * FROM save WHERE savedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM save WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM save WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySavename($value) {
        $sql = 'DELETE FROM save WHERE savename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavecurrentvalue($value) {
        $sql = 'DELETE FROM save WHERE savecurrentvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavedetails($value) {
        $sql = 'DELETE FROM save WHERE savedetails = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySavedate($value) {
        $sql = 'DELETE FROM save WHERE savedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM save WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM save WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SaveMySql
     */
    protected function readRow($row) {
        $save = new Save();

        $save->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $save->savename = isset($row['savename']) ? $row['savename'] : '';
        $save->savecurrentvalue = isset($row['savecurrentvalue']) ? $row['savecurrentvalue'] : '';
        $save->savedetails = isset($row['savedetails']) ? $row['savedetails'] : '';
        $save->savedate = isset($row['savedate']) ? $row['savedate'] : '';
        $save->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $save->userid = isset($row['userid']) ? $row['userid'] : '';
        $save->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $save->currencyName = isset($row['currencyName']) ? $row['currencyName'] : '';
        $save->conversionFactor = isset($row['conversionFactor']) ? $row['conversionFactor'] : '';
        $save->otherconversionFactor = isset($row['otherconversionFactor']) ? $row['otherconversionFactor'] : '';
        $save->savecurrentvalueInMainCurrency = isset($row['savecurrentvalueInMainCurrency']) ? $row['savecurrentvalueInMainCurrency'] : '';
        $save->sortby = isset($row['sortby']) ? $row['sortby'] : '';
        $save->treeId = isset($row['treeId']) ? $row['treeId'] : '';
        $save->saveTreeParentType = isset($row['saveTreeParentType']) ? $row['saveTreeParentType'] : '';

        return $save;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SaveMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>