<?php
/**
 * Class that operate on table 'saveclose'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-12-07 03:04
 */
class SavecloseMySqlDAO implements SavecloseDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return SavecloseMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM saveclose WHERE savecloseid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM saveclose';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM saveclose ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param saveclose primary key
 	 */
	public function delete($savecloseid){
		$sql = 'DELETE FROM saveclose WHERE savecloseid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($savecloseid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param SavecloseMySql saveclose
 	 */
	public function insert($saveclose){
		$sql = 'INSERT INTO saveclose (saveidfrom, saveidto, saveclosevalue, saveclosedate, userid, conditions, dailyentryid, comment, currencyId, conversionFactor, conversionFactorFrom, conversionFactorTo, saveclosevalueInCurrency) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($saveclose->saveidfrom);
		$sqlQuery->setNumber($saveclose->saveidto);
		$sqlQuery->set($saveclose->saveclosevalue);
		$sqlQuery->set($saveclose->saveclosedate);
		$sqlQuery->setNumber($saveclose->userid);
		$sqlQuery->setNumber($saveclose->conditions);
		$sqlQuery->setNumber($saveclose->dailyentryid);
		$sqlQuery->set($saveclose->comment);
		$sqlQuery->setNumber($saveclose->currencyId);
		$sqlQuery->set($saveclose->conversionFactor);
		$sqlQuery->set($saveclose->conversionFactorFrom);
		$sqlQuery->set($saveclose->conversionFactorTo);
		$sqlQuery->set($saveclose->saveclosevalueInCurrency);

		$id = $this->executeInsert($sqlQuery);	
		$saveclose->savecloseid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param SavecloseMySql saveclose
 	 */
	public function update($saveclose){
		$sql = 'UPDATE saveclose SET saveidfrom = ?, saveidto = ?, saveclosevalue = ?, saveclosedate = ?, userid = ?, conditions = ?, dailyentryid = ?, comment = ?, currencyId = ?, conversionFactor = ?, conversionFactorFrom = ?, conversionFactorTo = ?, saveclosevalueInCurrency = ? WHERE savecloseid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($saveclose->saveidfrom);
		$sqlQuery->setNumber($saveclose->saveidto);
		$sqlQuery->set($saveclose->saveclosevalue);
		$sqlQuery->set($saveclose->saveclosedate);
		$sqlQuery->setNumber($saveclose->userid);
		$sqlQuery->setNumber($saveclose->conditions);
		$sqlQuery->setNumber($saveclose->dailyentryid);
		$sqlQuery->set($saveclose->comment);
		$sqlQuery->setNumber($saveclose->currencyId);
		$sqlQuery->set($saveclose->conversionFactor);
		$sqlQuery->set($saveclose->conversionFactorFrom);
		$sqlQuery->set($saveclose->conversionFactorTo);
		$sqlQuery->set($saveclose->saveclosevalueInCurrency);

		$sqlQuery->setNumber($saveclose->savecloseid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM saveclose';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySaveidfrom($value){
		$sql = 'SELECT * FROM saveclose WHERE saveidfrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveidto($value){
		$sql = 'SELECT * FROM saveclose WHERE saveidto = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveclosevalue($value){
		$sql = 'SELECT * FROM saveclose WHERE saveclosevalue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveclosedate($value){
		$sql = 'SELECT * FROM saveclose WHERE saveclosedate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM saveclose WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM saveclose WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDailyentryid($value){
		$sql = 'SELECT * FROM saveclose WHERE dailyentryid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByComment($value){
		$sql = 'SELECT * FROM saveclose WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCurrencyId($value){
		$sql = 'SELECT * FROM saveclose WHERE currencyId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConversionFactor($value){
		$sql = 'SELECT * FROM saveclose WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConversionFactorFrom($value){
		$sql = 'SELECT * FROM saveclose WHERE conversionFactorFrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConversionFactorTo($value){
		$sql = 'SELECT * FROM saveclose WHERE conversionFactorTo = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveclosevalueInCurrency($value){
		$sql = 'SELECT * FROM saveclose WHERE saveclosevalueInCurrency = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySaveidfrom($value){
		$sql = 'DELETE FROM saveclose WHERE saveidfrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveidto($value){
		$sql = 'DELETE FROM saveclose WHERE saveidto = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveclosevalue($value){
		$sql = 'DELETE FROM saveclose WHERE saveclosevalue = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveclosedate($value){
		$sql = 'DELETE FROM saveclose WHERE saveclosedate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM saveclose WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM saveclose WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDailyentryid($value){
		$sql = 'DELETE FROM saveclose WHERE dailyentryid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByComment($value){
		$sql = 'DELETE FROM saveclose WHERE comment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCurrencyId($value){
		$sql = 'DELETE FROM saveclose WHERE currencyId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConversionFactor($value){
		$sql = 'DELETE FROM saveclose WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConversionFactorFrom($value){
		$sql = 'DELETE FROM saveclose WHERE conversionFactorFrom = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConversionFactorTo($value){
		$sql = 'DELETE FROM saveclose WHERE conversionFactorTo = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveclosevalueInCurrency($value){
		$sql = 'DELETE FROM saveclose WHERE saveclosevalueInCurrency = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return SavecloseMySql 
	 */
	protected function readRow($row){
		$saveclose = new Saveclose();
		
		$saveclose->savecloseid = $row['savecloseid'];
		$saveclose->saveidfrom = $row['saveidfrom'];
		$saveclose->saveidto = $row['saveidto'];
		$saveclose->saveclosevalue = $row['saveclosevalue'];
		$saveclose->saveclosedate = $row['saveclosedate'];
		$saveclose->userid = $row['userid'];
		$saveclose->conditions = $row['conditions'];
		$saveclose->dailyentryid = $row['dailyentryid'];
		$saveclose->comment = $row['comment'];
		$saveclose->currencyId = $row['currencyId'];
		$saveclose->conversionFactor = $row['conversionFactor'];
		$saveclose->conversionFactorFrom = $row['conversionFactorFrom'];
		$saveclose->conversionFactorTo = $row['conversionFactorTo'];
		$saveclose->saveclosevalueInCurrency = $row['saveclosevalueInCurrency'];
		$saveclose->savefromname = $row['savefromname'];

		return $saveclose;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return SavecloseMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>