<?php
/**
 * Class that operate on table 'sellbillcurr'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-03-08 08:37
 */
class SellbillcurrMySqlDAO implements SellbillcurrDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return SellbillcurrMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM sellbillcurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM sellbillcurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM sellbillcurr ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param sellbillcurr primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM sellbillcurr WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param SellbillcurrMySql sellbillcurr
 	 */
	public function insert($sellbillcurr){
		$sql = 'INSERT INTO sellbillcurr (sellbillid, conversionFactor, sellbilldiscountC, sellbilltotalbillC, sellbillaftertotalbillC, sellbilltotalpayedC, sellbillfinalbillC, sellbildirectpaymentC, taxC, deliveryC, totalafterdeliveryC, cashPayedC, visaPayedC, extraDiscountValC, taxOfDiscountValC, saveConversionFactor) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($sellbillcurr->sellbillid);
		$sqlQuery->set($sellbillcurr->conversionFactor);
		$sqlQuery->set($sellbillcurr->sellbilldiscountC);
		$sqlQuery->set($sellbillcurr->sellbilltotalbillC);
		$sqlQuery->set($sellbillcurr->sellbillaftertotalbillC);
		$sqlQuery->set($sellbillcurr->sellbilltotalpayedC);
		$sqlQuery->set($sellbillcurr->sellbillfinalbillC);
		$sqlQuery->setNumber($sellbillcurr->sellbildirectpaymentC);
		$sqlQuery->set($sellbillcurr->taxC);
		$sqlQuery->set($sellbillcurr->deliveryC);
		$sqlQuery->set($sellbillcurr->totalafterdeliveryC);
		$sqlQuery->set($sellbillcurr->cashPayedC);
		$sqlQuery->set($sellbillcurr->visaPayedC);
		$sqlQuery->set($sellbillcurr->extraDiscountValC);
		$sqlQuery->set($sellbillcurr->taxOfDiscountValC);
		$sqlQuery->set($sellbillcurr->saveConversionFactor);

		$id = $this->executeInsert($sqlQuery);	
		$sellbillcurr->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param SellbillcurrMySql sellbillcurr
 	 */
	public function update($sellbillcurr){
		$sql = 'UPDATE sellbillcurr SET sellbillid = ?, conversionFactor = ?, sellbilldiscountC = ?, sellbilltotalbillC = ?, sellbillaftertotalbillC = ?, sellbilltotalpayedC = ?, sellbillfinalbillC = ?, sellbildirectpaymentC = ?, taxC = ?, deliveryC = ?, totalafterdeliveryC = ?, cashPayedC = ?, visaPayedC = ?, extraDiscountValC = ?, taxOfDiscountValC = ?, saveConversionFactor = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($sellbillcurr->sellbillid);
		$sqlQuery->set($sellbillcurr->conversionFactor);
		$sqlQuery->set($sellbillcurr->sellbilldiscountC);
		$sqlQuery->set($sellbillcurr->sellbilltotalbillC);
		$sqlQuery->set($sellbillcurr->sellbillaftertotalbillC);
		$sqlQuery->set($sellbillcurr->sellbilltotalpayedC);
		$sqlQuery->set($sellbillcurr->sellbillfinalbillC);
		$sqlQuery->setNumber($sellbillcurr->sellbildirectpaymentC);
		$sqlQuery->set($sellbillcurr->taxC);
		$sqlQuery->set($sellbillcurr->deliveryC);
		$sqlQuery->set($sellbillcurr->totalafterdeliveryC);
		$sqlQuery->set($sellbillcurr->cashPayedC);
		$sqlQuery->set($sellbillcurr->visaPayedC);
		$sqlQuery->set($sellbillcurr->extraDiscountValC);
		$sqlQuery->set($sellbillcurr->taxOfDiscountValC);
		$sqlQuery->set($sellbillcurr->saveConversionFactor);

		$sqlQuery->setNumber($sellbillcurr->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM sellbillcurr';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryBySellbillid($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE sellbillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConversionFactor($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbilldiscountC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE sellbilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbilltotalbillC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE sellbilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbillaftertotalbillC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE sellbillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbilltotalpayedC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE sellbilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbillfinalbillC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE sellbillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySellbildirectpaymentC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE sellbildirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTaxC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE taxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByDeliveryC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE deliveryC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotalafterdeliveryC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE totalafterdeliveryC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByCashPayedC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE cashPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByVisaPayedC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE visaPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByExtraDiscountValC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE extraDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTaxOfDiscountValC($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE taxOfDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySaveConversionFactor($value){
		$sql = 'SELECT * FROM sellbillcurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteBySellbillid($value){
		$sql = 'DELETE FROM sellbillcurr WHERE sellbillid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConversionFactor($value){
		$sql = 'DELETE FROM sellbillcurr WHERE conversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbilldiscountC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE sellbilldiscountC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbilltotalbillC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE sellbilltotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbillaftertotalbillC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE sellbillaftertotalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbilltotalpayedC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE sellbilltotalpayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbillfinalbillC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE sellbillfinalbillC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySellbildirectpaymentC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE sellbildirectpaymentC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTaxC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE taxC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByDeliveryC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE deliveryC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotalafterdeliveryC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE totalafterdeliveryC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByCashPayedC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE cashPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByVisaPayedC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE visaPayedC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByExtraDiscountValC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE extraDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTaxOfDiscountValC($value){
		$sql = 'DELETE FROM sellbillcurr WHERE taxOfDiscountValC = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySaveConversionFactor($value){
		$sql = 'DELETE FROM sellbillcurr WHERE saveConversionFactor = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return SellbillcurrMySql 
	 */
	protected function readRow($row){
		$sellbillcurr = new Sellbillcurr();
		
		$sellbillcurr->id = $row['id'];
		$sellbillcurr->sellbillid = $row['sellbillid'];
		$sellbillcurr->conversionFactor = $row['conversionFactor'];
		$sellbillcurr->sellbilldiscountC = $row['sellbilldiscountC'];
		$sellbillcurr->sellbilltotalbillC = $row['sellbilltotalbillC'];
		$sellbillcurr->sellbillaftertotalbillC = $row['sellbillaftertotalbillC'];
		$sellbillcurr->sellbilltotalpayedC = $row['sellbilltotalpayedC'];
		$sellbillcurr->sellbillfinalbillC = $row['sellbillfinalbillC'];
		$sellbillcurr->sellbildirectpaymentC = $row['sellbildirectpaymentC'];
		$sellbillcurr->taxC = $row['taxC'];
		$sellbillcurr->deliveryC = $row['deliveryC'];
		$sellbillcurr->totalafterdeliveryC = $row['totalafterdeliveryC'];
		$sellbillcurr->cashPayedC = $row['cashPayedC'];
		$sellbillcurr->visaPayedC = $row['visaPayedC'];
		$sellbillcurr->extraDiscountValC = $row['extraDiscountValC'];
		$sellbillcurr->taxOfDiscountValC = $row['taxOfDiscountValC'];
		$sellbillcurr->saveConversionFactor = $row['saveConversionFactor'];

		return $sellbillcurr;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return SellbillcurrMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>