<?php

/**
 * Class that operate on table 'sparepartstorereport'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 15:22
 */
class SparepartstorereportMySqlDAO implements SparepartstorereportDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SparepartstorereportMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE sparepartstorereportid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sparepartstorereport';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sparepartstorereport ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sparepartstorereport primary key
     */
    public function delete($sparepartstorereportid) {
        $sql = 'DELETE FROM sparepartstorereport WHERE sparepartstorereportid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sparepartstorereportid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SparepartstorereportMySql sparepartstorereport
     */
    public function insert($sparepartstorereport) {
        $sql = 'INSERT INTO sparepartstorereport (sparepartid, sparepartstoreId, partquantity, storereporttype, storereportmodelid, processname, tablename, partbefore, partafter, userid, storereportdate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($sparepartstorereport->sparepartid);
        $sqlQuery->setNumber($sparepartstorereport->sparepartstoreId);
        $sqlQuery->setNumber($sparepartstorereport->partquantity);
        $sqlQuery->setNumber($sparepartstorereport->storereporttype);
        $sqlQuery->setNumber($sparepartstorereport->storereportmodelid);
        $sqlQuery->set($sparepartstorereport->processname);
        $sqlQuery->set($sparepartstorereport->tablename);
        $sqlQuery->setNumber($sparepartstorereport->partbefore);
        $sqlQuery->setNumber($sparepartstorereport->partafter);
        $sqlQuery->setNumber($sparepartstorereport->userid);
        $sqlQuery->set($sparepartstorereport->storereportdate);

        $id = $this->executeInsert($sqlQuery);
        $sparepartstorereport->sparepartstorereportid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SparepartstorereportMySql sparepartstorereport
     */
    public function update($sparepartstorereport) {
        $sql = 'UPDATE sparepartstorereport SET sparepartid = ?, sparepartstoreId = ?, partquantity = ?, storereporttype = ?, storereportmodelid = ?, processname = ?, tablename = ?, partbefore = ?, partafter = ?, userid = ?, storereportdate = ? WHERE sparepartstorereportid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($sparepartstorereport->sparepartid);
        $sqlQuery->setNumber($sparepartstorereport->sparepartstoreId);
        $sqlQuery->setNumber($sparepartstorereport->partquantity);
        $sqlQuery->setNumber($sparepartstorereport->storereporttype);
        $sqlQuery->setNumber($sparepartstorereport->storereportmodelid);
        $sqlQuery->set($sparepartstorereport->processname);
        $sqlQuery->set($sparepartstorereport->tablename);
        $sqlQuery->setNumber($sparepartstorereport->partbefore);
        $sqlQuery->setNumber($sparepartstorereport->partafter);
        $sqlQuery->setNumber($sparepartstorereport->userid);
        $sqlQuery->set($sparepartstorereport->storereportdate);

        $sqlQuery->setNumber($sparepartstorereport->sparepartstorereportid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sparepartstorereport';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySparepartid($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySparepartstoreId($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE sparepartstoreId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartquantity($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE partquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorereporttype($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE storereporttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorereportmodelid($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE storereportmodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartbefore($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE partbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPartafter($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE partafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorereportdate($value) {
        $sql = 'SELECT * FROM sparepartstorereport WHERE storereportdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySparepartid($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE sparepartid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySparepartstoreId($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE sparepartstoreId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartquantity($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE partquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorereporttype($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE storereporttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorereportmodelid($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE storereportmodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartbefore($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE partbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPartafter($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE partafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorereportdate($value) {
        $sql = 'DELETE FROM sparepartstorereport WHERE storereportdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SparepartstorereportMySql
     */
    protected function readRow($row) {
        $sparepartstorereport = new Sparepartstorereport();

        $sparepartstorereport->sparepartstorereportid = isset($row['sparepartstorereportid']) ? $row['sparepartstorereportid'] : '';
        $sparepartstorereport->sparepartid = isset($row['sparepartid']) ? $row['sparepartid'] : '';
        $sparepartstorereport->sparepartstoreId = isset($row['sparepartstoreId']) ? $row['sparepartstoreId'] : '';
        $sparepartstorereport->partquantity = isset($row['partquantity']) ? $row['partquantity'] : '';
        $sparepartstorereport->storereporttype = isset($row['storereporttype']) ? $row['storereporttype'] : '';
        $sparepartstorereport->storereportmodelid = isset($row['storereportmodelid']) ? $row['storereportmodelid'] : '';
        $sparepartstorereport->processname = isset($row['processname']) ? $row['processname'] : '';
        $sparepartstorereport->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $sparepartstorereport->partbefore = isset($row['partbefore']) ? $row['partbefore'] : '';
        $sparepartstorereport->partafter = isset($row['partafter']) ? $row['partafter'] : '';
        $sparepartstorereport->userid = isset($row['userid']) ? $row['userid'] : '';
        $sparepartstorereport->storereportdate = isset($row['storereportdate']) ? $row['storereportdate'] : '';

        return $sparepartstorereport;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SparepartstorereportMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>