<?php

/**
 * Class that operate on table 'supplierdebtchange'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class SupplierdebtchangeMySqlDAO implements SupplierdebtchangeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SupplierdebtchangeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierdebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        //print($sql);
        return $this->getRow($sqlQuery);
    }

    public function load1($id) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierdebtchangeid = ? and tablename = "supplierPayedDeptController.php"';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        //print($sql);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM supplierdebtchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM supplierdebtchange ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param supplierdebtchange primary key
     */
    public function delete($supplierdebtchangeid) {
        $sql = 'DELETE FROM supplierdebtchange WHERE supplierdebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($supplierdebtchangeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SupplierdebtchangeMySql supplierdebtchange
     */
    public function insert($supplierdebtchange) {
        $sql = 'INSERT INTO supplierdebtchange (supplierid, supplierdebtchangebefore, supplierdebtchangeamount, supplierdebtchangetype, processname, supplierdebtchangemodelid, supplierdebtchangeafter, supplierdebtchangedate, userid, tablename, comment, dailyentryid,saveid, costcenterid,currencyId,conversionFactor,payedInCurrency,saveConversionFactor,debtchangbeforeInSupplierCurrency,debtchangamountInSupplierCurrency,debtchangafterInSupplierCurrency) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $supplierdebtchange->currencyId = (empty($supplierdebtchange->currencyId)) ? 1 : $supplierdebtchange->currencyId;
        $supplierdebtchange->conversionFactor = (empty($supplierdebtchange->conversionFactor)) ? 1 : $supplierdebtchange->conversionFactor;
        $supplierdebtchange->payedInCurrency = (empty($supplierdebtchange->payedInCurrency)) ? $supplierdebtchange->supplierdebtchangeamount : $supplierdebtchange->payedInCurrency;
        $supplierdebtchange->saveConversionFactor = (empty($supplierdebtchange->saveConversionFactor)) ? 1 : $supplierdebtchange->saveConversionFactor;
        //
        $sqlQuery->setNumber($supplierdebtchange->supplierid);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangebefore);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangeamount);
        $sqlQuery->setNumber($supplierdebtchange->supplierdebtchangetype);
        $sqlQuery->set($supplierdebtchange->processname);
        $sqlQuery->setNumber($supplierdebtchange->supplierdebtchangemodelid);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangeafter);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangedate);
        $sqlQuery->setNumber($supplierdebtchange->userid);
        $sqlQuery->set($supplierdebtchange->tablename);
        $sqlQuery->setString2($supplierdebtchange->comment);
        $sqlQuery->setNumber($supplierdebtchange->dailyentryid);
        $sqlQuery->set($supplierdebtchange->saveid);
        $sqlQuery->setNumber((int) $supplierdebtchange->costcenterid);
        $sqlQuery->setNumber((int) $supplierdebtchange->currencyId);
        $sqlQuery->setNumber((float) $supplierdebtchange->conversionFactor);
        $sqlQuery->setNumber((float) $supplierdebtchange->payedInCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->saveConversionFactor);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangbeforeInSupplierCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangamountInSupplierCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangafterInSupplierCurrency);

        $id = $this->executeInsert($sqlQuery);
        $supplierdebtchange->supplierdebtchangeid = $id;
        return $id;
    }

    public function insert1($supplierdebtchange) {
        $sql = 'INSERT INTO supplierdebtchange (supplierid, supplierdebtchangebefore, supplierdebtchangeamount, supplierdebtchangetype, processname, supplierdebtchangemodelid, supplierdebtchangeafter, supplierdebtchangedate, userid, tablename, comment, del, dailyentryid,currencyId,conversionFactor,payedInCurrency,saveConversionFactor,debtchangbeforeInSupplierCurrency,debtchangamountInSupplierCurrency,debtchangafterInSupplierCurrency) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($supplierdebtchange->supplierid);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangebefore);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangeamount);
        $sqlQuery->setNumber($supplierdebtchange->supplierdebtchangetype);
        $sqlQuery->set($supplierdebtchange->processname);
        $sqlQuery->setNumber($supplierdebtchange->supplierdebtchangemodelid);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangeafter);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangedate);
        $sqlQuery->setNumber($supplierdebtchange->userid);
        $sqlQuery->set($supplierdebtchange->tablename);
        $sqlQuery->setString2($supplierdebtchange->comment);
        $sqlQuery->setNumber($supplierdebtchange->del);
        $sqlQuery->setNumber($supplierdebtchange->dailyentryid);
        $sqlQuery->setNumber((int) $supplierdebtchange->currencyId);
        $sqlQuery->setNumber((float) $supplierdebtchange->conversionFactor);
        $sqlQuery->setNumber((float) $supplierdebtchange->payedInCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->saveConversionFactor);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangbeforeInSupplierCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangamountInSupplierCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangafterInSupplierCurrency);

        $id = $this->executeInsert($sqlQuery);
        $supplierdebtchange->supplierdebtchangeid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SupplierdebtchangeMySql supplierdebtchange
     */
    public function update($supplierdebtchange) {
        $sql = 'UPDATE supplierdebtchange SET supplierid = ?, supplierdebtchangebefore = ?, supplierdebtchangeamount = ?, supplierdebtchangetype = ?, processname = ?, supplierdebtchangemodelid = ?, supplierdebtchangeafter = ?, supplierdebtchangedate = ?, userid = ?, tablename = ?, comment = ?, dailyentryid = ?,saveid = ?,currencyId=?,conversionFactor=?,payedInCurrency=?,saveConversionFactor=?,debtchangbeforeInSupplierCurrency=?,debtchangamountInSupplierCurrency=?,debtchangafterInSupplierCurrency=? WHERE supplierdebtchangeid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($supplierdebtchange->supplierid);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangebefore);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangeamount);
        $sqlQuery->setNumber($supplierdebtchange->supplierdebtchangetype);
        $sqlQuery->set($supplierdebtchange->processname);
        $sqlQuery->setNumber($supplierdebtchange->supplierdebtchangemodelid);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangeafter);
        $sqlQuery->set($supplierdebtchange->supplierdebtchangedate);
        $sqlQuery->setNumber($supplierdebtchange->userid);
        $sqlQuery->set($supplierdebtchange->tablename);
        $sqlQuery->setString2($supplierdebtchange->comment);
        $sqlQuery->setNumber($supplierdebtchange->dailyentryid);
        $sqlQuery->set($supplierdebtchange->saveid);
        $sqlQuery->setNumber((int) $supplierdebtchange->currencyId);
        $sqlQuery->setNumber((float) $supplierdebtchange->conversionFactor);
        $sqlQuery->setNumber((float) $supplierdebtchange->payedInCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->saveConversionFactor);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangbeforeInSupplierCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangamountInSupplierCurrency);
        $sqlQuery->setNumber((float) $supplierdebtchange->debtchangafterInSupplierCurrency);

        $sqlQuery->setNumber($supplierdebtchange->supplierdebtchangeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM supplierdebtchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySupplierdebtchangebefore($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierdebtchangebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangeamount($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierdebtchangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangetype($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierdebtchangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangemodelid($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierdebtchangemodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangeafter($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierdebtchangeafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierdebtchangedate($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierdebtchangedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySupplierdebtchangebefore($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE supplierdebtchangebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangeamount($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE supplierdebtchangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangetype($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE supplierdebtchangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangemodelid($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE supplierdebtchangemodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangeafter($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE supplierdebtchangeafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierdebtchangedate($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE supplierdebtchangedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM supplierdebtchange WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function loadBySupplierId($id) {
        $sql = 'SELECT * FROM supplierdebtchange WHERE supplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        //print($sql);
        return $this->getRow($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SupplierdebtchangeMySql
     */
    protected function readRow($row) {
        $supplierdebtchange = new Supplierdebtchange();

        $supplierdebtchange->supplierdebtchangeid = isset($row['supplierdebtchangeid']) ? $row['supplierdebtchangeid'] : '';
        $supplierdebtchange->supplierid = isset($row['supplierid']) ? $row['supplierid'] : '';
        $supplierdebtchange->supplierdebtchangebefore = isset($row['supplierdebtchangebefore']) ? $row['supplierdebtchangebefore'] : '';
        $supplierdebtchange->supplierdebtchangeamount = isset($row['supplierdebtchangeamount']) ? $row['supplierdebtchangeamount'] : '';
        $supplierdebtchange->supplierdebtchangetype = isset($row['supplierdebtchangetype']) ? $row['supplierdebtchangetype'] : '';
        $supplierdebtchange->processname = isset($row['processname']) ? $row['processname'] : '';
        $supplierdebtchange->supplierdebtchangemodelid = isset($row['supplierdebtchangemodelid']) ? $row['supplierdebtchangemodelid'] : '';
        $supplierdebtchange->supplierdebtchangeafter = isset($row['supplierdebtchangeafter']) ? $row['supplierdebtchangeafter'] : '';
        $supplierdebtchange->supplierdebtchangedate = isset($row['supplierdebtchangedate']) ? $row['supplierdebtchangedate'] : '';
        $supplierdebtchange->userid = isset($row['userid']) ? $row['userid'] : '';
        $supplierdebtchange->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $supplierdebtchange->comment = isset($row['comment']) ? $row['comment'] : '';
        $supplierdebtchange->finalstring = isset($row['finalstring']) ? $row['finalstring'] : '';
        $supplierdebtchange->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $supplierdebtchange->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $supplierdebtchange->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $supplierdebtchange->conversionFactor = isset($row['conversionFactor']) ? $row['conversionFactor'] : '';
        $supplierdebtchange->payedInCurrency = isset($row['payedInCurrency']) ? $row['payedInCurrency'] : '';
        $supplierdebtchange->saveConversionFactor = isset($row['saveConversionFactor']) ? $row['saveConversionFactor'] : '';
        $supplierdebtchange->debtchangbeforeInSupplierCurrency = isset($row['debtchangbeforeInSupplierCurrency']) ? $row['debtchangbeforeInSupplierCurrency'] : '';
        $supplierdebtchange->debtchangamountInSupplierCurrency = isset($row['debtchangamountInSupplierCurrency']) ? $row['debtchangamountInSupplierCurrency'] : '';
        $supplierdebtchange->debtchangafterInSupplierCurrency = isset($row['debtchangafterInSupplierCurrency']) ? $row['debtchangafterInSupplierCurrency'] : '';


        //required
        $supplierdebtchange->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $supplierdebtchange->del = isset($row['del']) ? $row['del'] : '';
        $supplierdebtchange->employeename = isset($row['employeename']) ? $row['employeename'] : '';

        ////////////////////eman////////////////
        $supplierdebtchange->username = isset($row['username']) ? $row['username'] : '';
        $supplierdebtchange->savename = isset($row['savename']) ? $row['savename'] : '';


        return $supplierdebtchange;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SupplierdebtchangeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>