<?php

/**
 * Class that operate on table 'supplieropen'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-07-20 15:34
 */
class SupplieropenMySqlDAO implements SupplieropenDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SupplieropenMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM supplieropen WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM supplieropen';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM supplieropen ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param supplieropen primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM supplieropen WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SupplieropenMySql supplieropen
     */
    public function insert($supplieropen) {
        $sql = 'INSERT INTO supplieropen (name, value, treeId, dailyentryid, userid, sysdate, del) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($supplieropen->name);
        $sqlQuery->set($supplieropen->value);
        $sqlQuery->setNumber($supplieropen->treeId);
        $sqlQuery->setNumber((int) $supplieropen->dailyentryid);
        $sqlQuery->setNumber($supplieropen->userid);
        $sqlQuery->set($supplieropen->sysdate);
        $sqlQuery->setNumber($supplieropen->del);

        $id = $this->executeInsert($sqlQuery);
        $supplieropen->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SupplieropenMySql supplieropen
     */
    public function update($supplieropen) {
        $sql = 'UPDATE supplieropen SET name = ?, value = ?, treeId = ?, dailyentryid = ?, userid = ?, sysdate = ?, del = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($supplieropen->name);
        $sqlQuery->set($supplieropen->value);
        $sqlQuery->setNumber($supplieropen->treeId);
        $sqlQuery->setNumber((int) $supplieropen->dailyentryid);
        $sqlQuery->setNumber($supplieropen->userid);
        $sqlQuery->set($supplieropen->sysdate);
        $sqlQuery->setNumber($supplieropen->del);

        $sqlQuery->setNumber($supplieropen->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM supplieropen';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM supplieropen WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByValue($value) {
        $sql = 'SELECT * FROM supplieropen WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTreeId($value) {
        $sql = 'SELECT * FROM supplieropen WHERE treeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM supplieropen WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM supplieropen WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM supplieropen WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM supplieropen WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM supplieropen WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByValue($value) {
        $sql = 'DELETE FROM supplieropen WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTreeId($value) {
        $sql = 'DELETE FROM supplieropen WHERE treeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM supplieropen WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM supplieropen WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM supplieropen WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM supplieropen WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SupplieropenMySql
     */
    protected function readRow($row) {
        $supplieropen = new Supplieropen();

        $supplieropen->id = $row['id'];
        $supplieropen->name = $row['name'];
        $supplieropen->value = $row['value'];
        $supplieropen->treeId = $row['treeId'];
        $supplieropen->dailyentryid = $row['dailyentryid'];
        $supplieropen->userid = $row['userid'];
        $supplieropen->sysdate = $row['sysdate'];
        $supplieropen->del = $row['del'];

        return $supplieropen;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SupplieropenMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>