<?php

/**
 * Class that operate on table 'temsellbill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-07-01 15:25
 */
class TemsellbillMySqlDAO implements TemsellbillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return TemsellbillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM temsellbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM temsellbill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param temsellbill primary key
     */
    public function delete($sellbillid) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param TemsellbillMySql temsellbill
     */
    public function insert($temsellbill) {
        $sql = 'INSERT INTO temsellbill (sellbilldate, sellbillserial, sellbillclientid, sellbilltotaldeptbefor, sellbilltotaldeptafter, sellbilldiscount, sellbilldiscounttype, sellbilltotalbill, sellbillaftertotalbill, sellbilltotalpayed, sellbillfinalbill, sellbillstoreid, sellbillsysdate, userid, conditions, sellbillclientname, sellbillsaveid, sellbildirectpayment, billnameid, sellerid, tempclientName, sellQuantity, deletedsellid, controlname, tax) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temsellbill->sellbilldate);
        $sqlQuery->set($temsellbill->sellbillserial);
        $sqlQuery->setNumber($temsellbill->sellbillclientid);
        $sqlQuery->set($temsellbill->sellbilltotaldeptbefor);
        $sqlQuery->set($temsellbill->sellbilltotaldeptafter);
        $sqlQuery->set($temsellbill->sellbilldiscount);
        $sqlQuery->setNumber($temsellbill->sellbilldiscounttype);
        $sqlQuery->set($temsellbill->sellbilltotalbill);
        $sqlQuery->set($temsellbill->sellbillaftertotalbill);
        $sqlQuery->set($temsellbill->sellbilltotalpayed);
        $sqlQuery->set($temsellbill->sellbillfinalbill);
        $sqlQuery->setNumber($temsellbill->sellbillstoreid);
        $sqlQuery->set($temsellbill->sellbillsysdate);
        $sqlQuery->setNumber($temsellbill->userid);
        $sqlQuery->setNumber($temsellbill->conditions);
        $sqlQuery->setString2($temsellbill->sellbillclientname);
        $sqlQuery->setNumber($temsellbill->sellbillsaveid);
        $sqlQuery->setNumber($temsellbill->sellbildirectpayment);
        $sqlQuery->setNumber($temsellbill->billnameid);
        $sqlQuery->setNumber($temsellbill->sellerid);
        $sqlQuery->set($temsellbill->tempclientName);
        $sqlQuery->set($temsellbill->sellQuantity);
        $sqlQuery->setNumber($temsellbill->deletedsellid);
        $sqlQuery->set($temsellbill->controlname);
        $sqlQuery->set($temsellbill->tax);

        $id = $this->executeInsert($sqlQuery);
        $temsellbill->sellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param TemsellbillMySql temsellbill
     */
    public function update($temsellbill) {
        $sql = 'UPDATE temsellbill SET sellbilldate = ?, sellbillserial = ?, sellbillclientid = ?, sellbilltotaldeptbefor = ?, sellbilltotaldeptafter = ?, sellbilldiscount = ?, sellbilldiscounttype = ?, sellbilltotalbill = ?, sellbillaftertotalbill = ?, sellbilltotalpayed = ?, sellbillfinalbill = ?, sellbillstoreid = ?, sellbillsysdate = ?, userid = ?, conditions = ?, sellbillclientname = ?, sellbillsaveid = ?, sellbildirectpayment = ?, billnameid = ?, sellerid = ?, tempclientName = ?, sellQuantity = ?, deletedsellid = ?, controlname = ?, tax = ? WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($temsellbill->sellbilldate);
        $sqlQuery->set($temsellbill->sellbillserial);
        $sqlQuery->setNumber($temsellbill->sellbillclientid);
        $sqlQuery->set($temsellbill->sellbilltotaldeptbefor);
        $sqlQuery->set($temsellbill->sellbilltotaldeptafter);
        $sqlQuery->set($temsellbill->sellbilldiscount);
        $sqlQuery->setNumber($temsellbill->sellbilldiscounttype);
        $sqlQuery->set($temsellbill->sellbilltotalbill);
        $sqlQuery->set($temsellbill->sellbillaftertotalbill);
        $sqlQuery->set($temsellbill->sellbilltotalpayed);
        $sqlQuery->set($temsellbill->sellbillfinalbill);
        $sqlQuery->setNumber($temsellbill->sellbillstoreid);
        $sqlQuery->set($temsellbill->sellbillsysdate);
        $sqlQuery->setNumber($temsellbill->userid);
        $sqlQuery->setNumber($temsellbill->conditions);
        $sqlQuery->setString2($temsellbill->sellbillclientname);
        $sqlQuery->setNumber($temsellbill->sellbillsaveid);
        $sqlQuery->setNumber($temsellbill->sellbildirectpayment);
        $sqlQuery->setNumber($temsellbill->billnameid);
        $sqlQuery->setNumber($temsellbill->sellerid);
        $sqlQuery->set($temsellbill->tempclientName);
        $sqlQuery->set($temsellbill->sellQuantity);
        $sqlQuery->setNumber($temsellbill->deletedsellid);
        $sqlQuery->set($temsellbill->controlname);
        $sqlQuery->set($temsellbill->tax);

        $sqlQuery->setNumber($temsellbill->sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM temsellbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySellbilldate($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillserial($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientid($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscount($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscounttype($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalbill($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalpayed($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillfinalbill($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillstoreid($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsysdate($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM temsellbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM temsellbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientname($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsaveid($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbildirectpayment($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM temsellbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempclientName($value) {
        $sql = 'SELECT * FROM temsellbill WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellQuantity($value) {
        $sql = 'SELECT * FROM temsellbill WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeletedsellid($value) {
        $sql = 'SELECT * FROM temsellbill WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByControlname($value) {
        $sql = 'SELECT * FROM temsellbill WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTax($value) {
        $sql = 'SELECT * FROM temsellbill WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySellbilldate($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillserial($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientid($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscount($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscounttype($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalbill($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillaftertotalbill($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalpayed($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillfinalbill($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillstoreid($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsysdate($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM temsellbill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM temsellbill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientname($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsaveid($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbildirectpayment($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM temsellbill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempclientName($value) {
        $sql = 'DELETE FROM temsellbill WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellQuantity($value) {
        $sql = 'DELETE FROM temsellbill WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeletedsellid($value) {
        $sql = 'DELETE FROM temsellbill WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByControlname($value) {
        $sql = 'DELETE FROM temsellbill WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTax($value) {
        $sql = 'DELETE FROM temsellbill WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return TemsellbillMySql
     */
    protected function readRow($row) {
        $temsellbill = new Temsellbill();

        $temsellbill->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $temsellbill->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';
        $temsellbill->sellbillserial = isset($row['sellbillserial']) ? $row['sellbillserial'] : '';
        $temsellbill->sellbillclientid = isset($row['sellbillclientid']) ? $row['sellbillclientid'] : '';
        $temsellbill->sellbilltotaldeptbefor = isset($row['sellbilltotaldeptbefor']) ? $row['sellbilltotaldeptbefor'] : '';
        $temsellbill->sellbilltotaldeptafter = isset($row['sellbilltotaldeptafter']) ? $row['sellbilltotaldeptafter'] : '';
        $temsellbill->sellbilldiscount = isset($row['sellbilldiscount']) ? $row['sellbilldiscount'] : '';
        $temsellbill->sellbilldiscounttype = isset($row['sellbilldiscounttype']) ? $row['sellbilldiscounttype'] : '';
        $temsellbill->sellbilltotalbill = isset($row['sellbilltotalbill']) ? $row['sellbilltotalbill'] : '';
        $temsellbill->sellbillaftertotalbill = isset($row['sellbillaftertotalbill']) ? $row['sellbillaftertotalbill'] : '';
        $temsellbill->sellbilltotalpayed = isset($row['sellbilltotalpayed']) ? $row['sellbilltotalpayed'] : '';
        $temsellbill->sellbillfinalbill = isset($row['sellbillfinalbill']) ? $row['sellbillfinalbill'] : '';
        $temsellbill->sellbillstoreid = isset($row['sellbillstoreid']) ? $row['sellbillstoreid'] : '';
        $temsellbill->sellbillsysdate = isset($row['sellbillsysdate']) ? $row['sellbillsysdate'] : '';
        $temsellbill->userid = isset($row['userid']) ? $row['userid'] : '';
        $temsellbill->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $temsellbill->sellbillclientname = isset($row['sellbillclientname']) ? $row['sellbillclientname'] : '';
        $temsellbill->sellbillsaveid = isset($row['sellbillsaveid']) ? $row['sellbillsaveid'] : '';
        $temsellbill->sellbildirectpayment = isset($row['sellbildirectpayment']) ? $row['sellbildirectpayment'] : '';
        $temsellbill->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $temsellbill->sellerid = isset($row['sellerid']) ? $row['sellerid'] : '';
        $temsellbill->tempclientName = isset($row['tempclientName']) ? $row['tempclientName'] : '';
        $temsellbill->sellQuantity = isset($row['sellQuantity']) ? $row['sellQuantity'] : '';
        $temsellbill->deletedsellid = isset($row['deletedsellid']) ? $row['deletedsellid'] : '';
        $temsellbill->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $temsellbill->tax = isset($row['tax']) ? $row['tax'] : '';

        return $temsellbill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return TemsellbillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>