<?php

/**
 * Class that operate on table 'workstation'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
class WorkstationMySqlDAO implements WorkstationDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return WorkstationMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM workstation WHERE workstationid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM workstation';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM workstation ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param workstation primary key
     */
    public function delete($workstationid) {
        $sql = 'DELETE FROM workstation WHERE workstationid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($workstationid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param WorkstationMySql workstation
     */
    public function insert($workstation) {
        $sql = 'INSERT INTO workstation (workname, workerhours, assetshours, date, conditions, user_id) VALUES (?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->set($workstation->workname);
        $sqlQuery->set($workstation->workerhours);
        $sqlQuery->set($workstation->assetshours);
        $sqlQuery->set($workstation->date);
        $sqlQuery->setNumber($workstation->conditions);
        $sqlQuery->setNumber($workstation->userId);
        //print_r($sqlQuery);
        $id = $this->executeInsert($sqlQuery);
        $workstation->workstationid = $id;


        return $id;
    }

    /**
     * Update record in table
     *
     * @param WorkstationMySql workstation
     */
    public function update($workstation) {
        $sql = 'UPDATE workstation SET workname = ?, workerhours = ?, assetshours = ?, date = ?, conditions = ?, user_id = ? WHERE workstationid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($workstation->workname);
        $sqlQuery->set($workstation->workerhours);
        $sqlQuery->set($workstation->assetshours);
        $sqlQuery->set($workstation->date);
        $sqlQuery->setNumber($workstation->conditions);
        $sqlQuery->setNumber($workstation->userId);

        $sqlQuery->setNumber($workstation->workstationid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM workstation';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByWorkname($value) {
        $sql = 'SELECT * FROM workstation WHERE workname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkerhours($value) {
        $sql = 'SELECT * FROM workstation WHERE workerhours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAssetshours($value) {
        $sql = 'SELECT * FROM workstation WHERE assetshours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEfficiency($value) {
        $sql = 'SELECT * FROM workstation WHERE efficiency = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDate($value) {
        $sql = 'SELECT * FROM workstation WHERE date = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM workstation WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM workstation WHERE user_id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByWorkname($value) {
        $sql = 'DELETE FROM workstation WHERE workname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkerhours($value) {
        $sql = 'DELETE FROM workstation WHERE workerhours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAssetshours($value) {
        $sql = 'DELETE FROM workstation WHERE assetshours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEfficiency($value) {
        $sql = 'DELETE FROM workstation WHERE efficiency = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDate($value) {
        $sql = 'DELETE FROM workstation WHERE date = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM workstation WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM workstation WHERE user_id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return WorkstationMySql
     */
    protected function readRow($row) {
        $workstation = new Workstation();

        $workstation->workstationid = isset($row['workstationid']) ? $row['workstationid'] : '';
        $workstation->workname = isset($row['workname']) ? $row['workname'] : '';
        $workstation->workerhours = isset($row['workerhours']) ? $row['workerhours'] : '';
        $workstation->assetshours = isset($row['assetshours']) ? $row['assetshours'] : '';
        $workstation->date = isset($row['date']) ? $row['date'] : '';
        $workstation->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $workstation->userId = isset($row['user_id']) ? $row['user_id'] : '';

        return $workstation;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return WorkstationMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>