<?php

/**
 * Class that operate on table 'savedaily'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-08-07 11:25
 */
class SavedailyMySqlExtDAO extends SavedailyMySqlDAO {

    public function queryAllSave($saveid) {
        $sql = 'SELECT savedaily.*, save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.saveid=' . $saveid . ' and save.conditions=0 order by savedaily.savedailyid desc ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllDate($startDate, $endDate) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.savedailydate >= "' . $startDate . '" and  savedaily.savedailydate <= "' . $endDate . '" and save.conditions=0 order by savedaily.savedailyid desc ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateAndSaveId($saveid, $startDate, $endDate) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.savedailydate >= "' . $startDate . '" and  savedaily.savedailydate <= "' . $endDate . '"
		and save.conditions=0 and savedaily.saveid=' . $saveid . '
		 order by savedaily.savedailyid desc ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDate($startDate, $endDate) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.savedailydate >= "' . $startDate . '" and savedaily.savedailydate <=  "' . $endDate . '"
		and save.conditions=0
		 order by savedaily.savedailyid desc ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllLimit() {
        $sql = 'SELECT savedaily.*, save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where save.conditions=0 order by savedaily.savedailyid desc ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllBysavedailyid($savedailyid) {
        $sql = 'SELECT savedaily.*, save.savename, save.savecurrentvalue FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where save.conditions=0  and savedaily.savedailyid=' . $savedailyid . ' order by savedaily.savedailyid desc ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    //////////////////////تسوية الخزن///////////////////////////////

    public function queryWithModelId() {
        $sql = 'SELECT savedaily.*, save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.savedailymodelid= -1  and save.conditions=0 order by savedaily.savedailyid desc ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithModelIdAndSave($saveid) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.saveid =' . $saveid . ' and savedaily.savedailymodelid= -1
		and save.conditions=0 order by savedaily.savedailyid desc ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithModelIdAndDate($startDate, $endDate) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.savedailydate >= "' . $startDate . '" and savedaily.savedailydate <=  "' . $endDate . '"
		 and savedaily.savedailymodelid= -1
		 and save.conditions=0 order by savedaily.savedailyid desc ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithTablename($tablename) {
        $sql = 'SELECT savedaily.*, save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.tablename= "' . $tablename . '"
		and save.conditions=0 order by savedaily.savedailyid desc ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithTablenameAndSave($saveid, $tablename) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.saveid =' . $saveid . '
		and savedaily.tablename= "' . $tablename . '"
		and save.conditions=0 order by savedaily.savedailyid desc ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function querybyqueryString($queryString) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where ' . $queryString . '
		and save.conditions=0 order by savedaily.savedailyid desc ';


        //print_r($sql . '<br>');
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithTablenameAndDate($startDate, $endDate, $tablename) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.savedailydate >= "' . $startDate . '" and  savedaily.savedailydate <= "' . $endDate . '"
		and savedaily.tablename= "' . $tablename . '"
		 and save.conditions=0 order by savedaily.savedailyid desc ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateSavedailymodelid($savedaily) {
        $sql = 'UPDATE savedaily SET  savedailymodelid = ? WHERE savedailyid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($savedaily->savedailymodelid);

        $sqlQuery->setNumber($savedaily->savedailyid);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryAllPROCESS() {
        $sql = 'SELECT DISTINCT processname ,savedailyid FROM savedaily group by processname';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    ////////////////////////////////////////nooooooooooor/////////////////////////////////

    public function searchInAdsindex11($queryString) {
        $sql = 'SELECT  savedaily.*, CONCAT(  `tablename` ,  `savedailymodelid` , savedailychangeamount,`savedailychangetype` ) AS finalstring ,save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
		' . $queryString . '
		and save.conditions=0
		order by    savedaily.savedailyid desc
		';


        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function searchInAdsindex22($endDate) {
        $sql = 'SELECT  savedaily.*, CONCAT(  `tablename` ,  `savedailymodelid` , savedailychangeamount,`savedailychangetype` ) AS finalstring ,save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.savedailydate > "' . $endDate . '"
		and save.conditions=0
		order by  savedailyid asc LIMIT  1
		';

        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function loadbysaveidandprocessid($saveid, $proceesid) {
        $sql = 'SELECT savedaily.*, save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.saveid=' . $saveid . '
		and savedaily.savedailyid=' . $proceesid . '
		order by savedaily.savedailyid desc ';
        ;

        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($saveid);
        $sqlQuery->setNumber($proceesid);
        return $this->getRow($sqlQuery);
    }

    ////////eman////////////////////////////
    public function searchInAdsindexWithUsername($queryString) {
        $sql = 'SELECT  savedaily.*, user.employeename as username, CONCAT(  `tablename` ,  `savedailymodelid` , savedailychangeamount,`savedailychangetype` ) AS finalstring ,save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
                join user on user.userid = savedaily.userid
		' . $queryString . '
		and save.conditions=0
		order by    savedaily.savedailyid asc
		';


        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function searchInAdsindex2WithUsername($endDate) {
        $sql = 'SELECT  savedaily.*, user.username, CONCAT(  `tablename` ,  `savedailymodelid` , savedailychangeamount,`savedailychangetype` ) AS finalstring ,save.savename FROM savedaily join save
		on savedaily.saveid =  save.saveid
                join user on user.userid = savedaily.userid
		where savedaily.savedailydate > "' . $endDate . '"
		and save.conditions=0
		order by  savedailyid asc LIMIT  1
		';

        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function queryWithUserIdAndDate($startDate, $endDate, $user_id) {
        $sql = 'SELECT savedaily.*, save.savename
		FROM savedaily join save
		on savedaily.saveid =  save.saveid
		where savedaily.savedailydate >= "' . $startDate . '" and savedaily.savedailydate <=  "' . $endDate . '"
		 and savedaily.userid= ' . $user_id . '
		 and save.conditions=0 order by savedaily.savedailyid desc ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

}

?>