$('.classLate, [id^="latePeriod"]').live('keyup change', function () {
    //show hide part
    var empid = $(this).data('id');
    var itr = $(this).data('itr');
    var value = Number($(this).val());
    if (value > 0) {
        $('#lateHasPermissionLabel' + empid + '_' + itr).show();
    } else {
        $('#lateHasPermission' + empid + '_' + itr).removeAttr('checked');
        // $('#lateHasPermissionLabel' + empid + '_' + itr).hide();
        $('#lateDiscount' + empid + '_' + itr).val("");
    }
    //calc late part
    var lateMinutes = Number($('#latePeriod' + empid + '_' + itr).val());
    var sys = JSON.parse($('#system' + empid + '_' + itr).val());
    var hasPermission = 0;
    if ($('#lateHasPermission' + empid + '_' + itr).prop("checked")) {//$('#lateHasPermission' + empid).is('checked');
        hasPermission = 1;
    }
    if (lateMinutes > 0 && sys) {
        var lateDiscount = calcLateDisount(lateMinutes, hasPermission, sys);
        $('#lateDiscount' + empid + '_' + itr).val(lateDiscount);
    } else {
        $('#lateDiscount' + empid + '_' + itr).val(0);
    }
});
/*----------------------------------------------------------------------*/
$(document).on('change', '.attendanceTime', function () {
    var attendance = $(this).val();
    var empid = $(this).data('id');
    var itr = $(this).data('itr');
    var sys = JSON.parse($('#system' + empid + '_' + itr).val());
    var sysattendance = sys.attendanceTime;

    if (attendance != "" && sysattendance != "") {
        var timeAttendance = new Date(0, 0, 0, attendance.split(":")[0], attendance.split(":")[1], 0);//Date.now();
        var timeSys = new Date(0, 0, 0, sysattendance.split(":")[0], sysattendance.split(":")[1], 0);//Date.now();
        var lateMinutes = (timeAttendance - timeSys) / (1000 * 60);
        if (lateMinutes < 0) {
            lateMinutes = 0;
        }
        $('#latePeriod' + empid + '_' + itr).val(lateMinutes).change();
    }
});
$(document).on('change', '.lateHasPermission', function () {
    var empid = $(this).data('id');
    var itr = $(this).data('itr');
    $('#latePeriod' + empid + '_' + itr).change();
});

$('#addAttendanceData').on('click', function (e) {
    e.preventDefault();
    e.stopPropagation();
    var ids = '';
    $(".choosenItem:checked").each(function () {
        ids += $(this).val() + ',';
    });
    if (ids != "") {
        $('#attendanceExcelForm').submit();
    } else {
        alert('عفوا اختر عناصر اولا');
    }
});

function calcLateDisount(lateMinutes, hasPermission, sys) {
    var lateDiscount = '';
    if (lateMinutes > 0 && lateMinutes <= 30) {
        if (hasPermission == 1) {
            lateDiscount = sys.halfHourLateWithPermissionDisount;
        } else {
            lateDiscount = sys.halfHourLateWithoutPermissionDisount;
        }
    } else if (lateMinutes > 30 && lateMinutes <= 60) {
        if (hasPermission == 1) {
            lateDiscount = sys.hourLateWithPermissionDisount;
        } else {
            lateDiscount = sys.hourLateWithoutPermissionDisount;
        }
    } else if (lateMinutes > 60 && lateMinutes <= 90) {
        if (hasPermission == 1) {
            lateDiscount = sys.hourAndHalfLateWithPermissionDisount;
        } else {
            lateDiscount = sys.hourAndHalfLateWithoutPermissionDisount;
        }
    } else if (lateMinutes > 90 && lateMinutes <= 120) {
        if (hasPermission == 1) {
            lateDiscount = sys.twoHoursLateWithPermissionDisount;
        } else {
            lateDiscount = sys.twoHoursLateWithoutPermissionDisount;
        }
    } else if (lateMinutes > 120) {
        if (hasPermission == 1) {
            lateDiscount = sys.moreThanTwoHoursLateWithPermissionDisount;
        } else {
            lateDiscount = sys.moreThanTwoHoursLateWithoutPermissionDisount;
        }
    }

    return lateDiscount;
}
